/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.threetag.palladium.command.EntitySelectorParserExtension;
import net.threetag.palladium.mixin.EntitySelectorOptionsInvoker;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladiumcore.util.Platform;

public class PalladiumEntitySelectorOptions {
    public static final Component POWER_DESCRIPTION = Component.m_237115_((String)"argument.entity.options.palladium.power.description");

    public static void init() {
        EntitySelectorOptionsInvoker.callRegister("palladium.power", parser -> PalladiumEntitySelectorOptions.cast(parser).palladium$setPower(PalladiumEntitySelectorOptions.parsePowerId(parser)), parser -> PalladiumEntitySelectorOptions.cast(parser).palladium$getPower() == null, POWER_DESCRIPTION);
    }

    private static EntitySelectorParserExtension cast(EntitySelectorParser parser) {
        return (EntitySelectorParserExtension)parser;
    }

    private static ResourceLocation parsePowerId(EntitySelectorParser parser) throws CommandSyntaxException {
        PowerManager powers = PowerManager.getInstance(Platform.isServer());
        parser.m_121270_((builder, consumer) -> {
            PalladiumEntitySelectorOptions.suggestIdentifiersIgnoringNamespace("palladium", powers.getIds(), builder);
            return builder.buildFuture();
        });
        return ResourceLocation.m_135818_((StringReader)parser.m_121346_());
    }

    public static CompletableFuture<Suggestions> suggestIdentifiersIgnoringNamespace(String namespace, Iterable<ResourceLocation> candidates, SuggestionsBuilder builder) {
        PalladiumEntitySelectorOptions.forEachMatchingIgnoringNamespace(namespace, candidates, builder.getRemaining().toLowerCase(Locale.ROOT), Function.identity(), id -> builder.suggest(String.valueOf(id)));
        return builder.buildFuture();
    }

    public static <T> void forEachMatchingIgnoringNamespace(String namespace, Iterable<T> candidates, String string, Function<T, ResourceLocation> idFunc, Consumer<T> action) {
        boolean hasColon = string.indexOf(58) > -1;
        for (T object : candidates) {
            ResourceLocation id = idFunc.apply(object);
            if (hasColon) {
                if (!PalladiumEntitySelectorOptions.wordStartsWith(string, id.toString(), '_')) continue;
                action.accept(object);
                continue;
            }
            if (!PalladiumEntitySelectorOptions.wordStartsWith(string, id.m_135827_(), '_') && (!id.m_135827_().equals(namespace) || !PalladiumEntitySelectorOptions.wordStartsWith(string, id.m_135815_(), '_'))) continue;
            action.accept(object);
        }
    }

    public static boolean wordStartsWith(String string, String substring, char wordSeparator) {
        int i = 0;
        while (!substring.startsWith(string, i)) {
            if ((i = substring.indexOf(wordSeparator, i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

