/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.compat.geckolib.armor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.threetag.palladium.addonpack.parser.ArmorMaterialParser;
import net.threetag.palladium.addonpack.parser.ItemParser;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.compat.geckolib.GeckoLibCompat;
import net.threetag.palladium.compat.geckolib.playeranimator.ParsedAnimationController;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.item.AddonArmorItem;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.util.json.GsonUtil;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AddonGeoArmorItem
extends AddonArmorItem
implements GeoItem {
    public List<ParsedAnimationController<GeoItem>> animationControllers;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public ResourceLocation modelPath;
    public TextureReference texturePath;
    public ResourceLocation animationsPath;

    public AddonGeoArmorItem(ArmorMaterial materialIn, ArmorItem.Type type, Item.Properties builder) {
        super(materialIn, type, builder);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        for (ParsedAnimationController<GeoItem> controller : this.animationControllers) {
            controllerRegistrar.add(new AnimationController[]{controller.createController(this)});
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public boolean hasCustomRenderer() {
        return false;
    }

    public static class Parser
    implements ItemParser.ItemTypeSerializer {
        @Override
        public IAddonItem parse(JsonObject json, Item.Properties properties) {
            ArmorMaterial armorMaterial = ArmorMaterialParser.getArmorMaterial(GsonUtil.getAsResourceLocation(json, "armor_material"));
            if (armorMaterial == null) {
                throw new JsonParseException("Unknown armor material '" + String.valueOf(GsonUtil.getAsResourceLocation(json, "armor_material")) + "'");
            }
            ArmorItem.Type type = AddonArmorItem.Parser.getArmorType(GsonHelper.m_13906_((JsonObject)json, (String)"slot"));
            if (type == null) {
                throw new JsonParseException("Armor slot must be one of the following: " + Arrays.toString(Arrays.stream(ArmorItem.Type.values()).map(ArmorItem.Type::m_266355_).toArray()));
            }
            AddonGeoArmorItem item = GeckoLibCompat.createArmorItem(armorMaterial, type, properties);
            item.modelPath = GsonUtil.getAsResourceLocation(json, "armor_model", null);
            item.texturePath = GsonUtil.getAsTextureReference(json, "armor_texture", null);
            item.animationsPath = GsonUtil.getAsResourceLocation(json, "armor_animations", null);
            item.animationControllers = GsonUtil.fromListOrPrimitive(json.get("armor_animation_controller"), el -> ParsedAnimationController.controllerFromJson(el.getAsJsonObject()), Collections.emptyList());
            return item;
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("GeckoLib Armor");
            builder.addProperty("slot", ArmorItem.Type.class).description("The slot the item will fit in. Possible values: " + Arrays.toString(Arrays.stream(ArmorItem.Type.values()).map(ArmorItem.Type::m_266355_).toArray())).required().exampleJson((JsonElement)new JsonPrimitive("chest"));
            builder.addProperty("armor_material", ArmorMaterial.class).description("Armor material, which defines certain characteristics about the armor. Open armor_materials.html for seeing how to make custom ones. Possible values: " + Arrays.toString(ArmorMaterialParser.getIds().toArray(new ResourceLocation[0]))).required().exampleJson((JsonElement)new JsonPrimitive("minecraft:diamond"));
            builder.addProperty("armor_model", ResourceLocation.class).description("Path to geckolib model file. Required bones: [armorHead, armorBody, armorRightArm, armorLeftArm, armorRightLeg, armorLeftLeg, armorRightBoot, armorLeftBoot].").fallback(null).exampleJson((JsonElement)new JsonPrimitive("palladium:test_model.geo.json"));
            builder.addProperty("armor_texture", TextureReference.class).description("Location of the armor texture. Can also use a dynamic texture using #.").fallback(null).exampleJson((JsonElement)new JsonPrimitive("example:textures/models/armor/example_armor.png"));
            builder.addProperty("armor_animations", ResourceLocation.class).description("ID of the animations that will be used.").fallback(null).exampleJson((JsonElement)new JsonPrimitive("palladium:animations/test_animation.animation.json"));
            JsonArray animationsExample = new JsonArray();
            JsonObject extendedC = new JsonObject();
            extendedC.addProperty("name", "controller_name");
            extendedC.addProperty("animation", "animation_name");
            extendedC.addProperty("transition_tick_time", (Number)10);
            JsonObject triggers = new JsonObject();
            triggers.addProperty("trigger_name", "animation_name");
            extendedC.add("triggers", (JsonElement)triggers);
            animationsExample.add((JsonElement)extendedC);
            builder.addProperty("armor_animation_controller", List.class).description("Names of controllers for the animation.").fallbackObject(null).exampleJson((JsonElement)animationsExample);
            builder.addProperty("hide_second_player_layer", Boolean.class).description("If enabled, the second player layer will be hidden when worn (only on the corresponding body part)").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }

        @Override
        public ResourceLocation getId() {
            return new ResourceLocation("geckolib", "armor");
        }
    }
}

