/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.compat.geckolib.forge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;
import net.threetag.palladium.compat.geckolib.ability.ArmorAnimationAbility;
import net.threetag.palladium.compat.geckolib.ability.RenderLayerAnimationAbility;
import net.threetag.palladium.compat.geckolib.armor.AddonGeoArmorItem;
import net.threetag.palladium.compat.geckolib.armor.GeckoArmorRenderer;
import net.threetag.palladium.compat.geckolib.renderlayer.GeckoRenderLayerModel;
import net.threetag.palladium.mixin.client.GeoArmorRendererInvoker;
import net.threetag.palladium.power.ability.Ability;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.util.RenderUtils;

public class GeckoLibCompatImpl {
    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(GeckoLibCompatImpl::registerAbility);
    }

    public static void registerAbility(RegisterEvent e) {
        e.register(Ability.REGISTRY.getRegistryKey(), new ResourceLocation("geckolib", "render_layer_animation"), RenderLayerAnimationAbility::new);
        e.register(Ability.REGISTRY.getRegistryKey(), new ResourceLocation("geckolib", "armor_animation"), ArmorAnimationAbility::new);
    }

    public static AddonGeoArmorItem createArmorItem(ArmorMaterial materialIn, ArmorItem.Type type, Item.Properties builder) {
        return new ArmorItemImpl(materialIn, type, builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderFirstPerson(AbstractClientPlayer player, ItemStack stack, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, ModelPart rendererArm, boolean rightArm) {
        Item item = stack.m_41720_();
        if (item instanceof ArmorItemImpl) {
            GeoBone bone;
            ArmorItemImpl gecko = (ArmorItemImpl)item;
            IClientItemExtensions rendererProvider = IClientItemExtensions.of((ItemStack)stack);
            PlayerModel origModel = (PlayerModel)((PlayerRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)player)).m_7200_();
            GeckoArmorRenderer renderer = (GeckoArmorRenderer)rendererProvider.getHumanoidArmorModel((LivingEntity)player, stack, EquipmentSlot.CHEST, (HumanoidModel)origModel);
            if (rendererProvider instanceof GeoArmorRendererInvoker) {
                GeoArmorRendererInvoker invoker = (GeoArmorRendererInvoker)rendererProvider;
                invoker.invokeGrabRelevantBones(renderer.getGeoModel().getBakedModel(renderer.getGeoModel().getModelResource((GeoAnimatable)gecko)));
            }
            GeoBone geoBone = bone = rightArm ? renderer.getRightArmBone() : renderer.getLeftArmBone();
            if (bone != null) {
                float partialTick = Minecraft.m_91087_().m_91296_();
                RenderType renderType = renderer.getRenderType(gecko, renderer.getTextureLocation((GeoAnimatable)gecko), bufferSource, partialTick);
                VertexConsumer buffer = ItemRenderer.m_115184_((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)false, (boolean)stack.m_41790_());
                RenderUtils.matchModelPartRot((ModelPart)rendererArm, (CoreGeoBone)bone);
                GeckoRenderLayerModel.copyScaleAndVisibility(rendererArm, (CoreGeoBone)bone);
                bone.updatePosition(rendererArm.f_104200_ + (float)(rightArm ? 5 : -5), 2.0f - rendererArm.f_104201_, rendererArm.f_104202_);
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, 1.5f, 0.0f);
                poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
                Color renderColor = renderer.getRenderColor((GeoAnimatable)gecko, partialTick, combinedLight);
                float red = renderColor.getRedFloat();
                float green = renderColor.getGreenFloat();
                float blue = renderColor.getBlueFloat();
                float alpha = renderColor.getAlphaFloat();
                int packedOverlay = renderer.getPackedOverlay((GeoAnimatable)gecko, 0.0f, partialTick);
                AnimationState animationState = new AnimationState((GeoAnimatable)gecko, 0.0f, 0.0f, partialTick, false);
                long instanceId = renderer.getInstanceId((Item)gecko);
                animationState.setData(DataTickets.TICK, (Object)gecko.getTick(player));
                animationState.setData(DataTickets.ITEMSTACK, (Object)stack);
                animationState.setData(DataTickets.ENTITY, (Object)player);
                animationState.setData(DataTickets.EQUIPMENT_SLOT, (Object)EquipmentSlot.CHEST);
                renderer.getGeoModel().addAdditionalStateData((GeoAnimatable)gecko, instanceId, (arg_0, arg_1) -> ((AnimationState)animationState).setData(arg_0, arg_1));
                renderer.getGeoModel().handleAnimations((GeoAnimatable)gecko, instanceId, animationState);
                renderer.renderRecursively(poseStack, (Item)gecko, bone, renderType, bufferSource, buffer, false, partialTick, combinedLight, packedOverlay, red, green, blue, alpha);
                poseStack.m_85849_();
            }
        }
    }

    public static class ArmorItemImpl
    extends AddonGeoArmorItem {
        public ArmorItemImpl(ArmorMaterial materialIn, ArmorItem.Type type, Item.Properties builder) {
            super(materialIn, type, builder);
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){
                private GeckoArmorRenderer<?> renderer;

                @NotNull
                public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                    if (this.renderer == null) {
                        this.renderer = new GeckoArmorRenderer((AddonGeoArmorItem)itemStack.m_41720_());
                    }
                    this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                    return this.renderer;
                }
            });
        }
    }
}

