/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.compat.kubejs;

import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.AttachedData;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.client.model.animation.AnimationUtil;
import net.threetag.palladium.client.model.animation.PalladiumAnimation;
import net.threetag.palladium.compat.kubejs.GuiUtilJS;
import net.threetag.palladium.compat.kubejs.PalladiumBinding;
import net.threetag.palladium.compat.kubejs.PalladiumBindingClient;
import net.threetag.palladium.compat.kubejs.PalladiumJSEvents;
import net.threetag.palladium.compat.kubejs.PowerHandlerJS;
import net.threetag.palladium.compat.kubejs.PowerManagerJS;
import net.threetag.palladium.compat.kubejs.ProjectileTickEventJS;
import net.threetag.palladium.compat.kubejs.RegisterAnimationsEventJS;
import net.threetag.palladium.compat.kubejs.RegisterGuiOverlaysEventJS;
import net.threetag.palladium.compat.kubejs.RegisterPalladiumPropertyEventJS;
import net.threetag.palladium.compat.kubejs.RenderPowerScreenEventJS;
import net.threetag.palladium.compat.kubejs.ability.AbilityBuilder;
import net.threetag.palladium.compat.kubejs.condition.ConditionBuilder;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.entity.CustomProjectile;
import net.threetag.palladium.event.PalladiumClientEvents;
import net.threetag.palladium.event.PalladiumEvents;
import net.threetag.palladium.power.SuperpowerUtil;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.util.Easing;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladiumcore.registry.client.OverlayRegistry;

public class PalladiumKubeJSPlugin
extends KubeJSPlugin {
    public static RegistryInfo<Ability> ABILITY = RegistryInfo.of((ResourceKey)Ability.REGISTRY.getRegistryKey(), Ability.class);
    public static RegistryInfo<ConditionSerializer> CONDITION = RegistryInfo.of((ResourceKey)ConditionSerializer.REGISTRY.getRegistryKey(), ConditionSerializer.class);

    public void init() {
        ABILITY.addType("basic", AbilityBuilder.class, AbilityBuilder::new);
        CONDITION.addType("basic", ConditionBuilder.class, ConditionBuilder::new);
        PalladiumJSEvents.GROUP.register();
        CustomProjectile.KUBEJS_EVENT_HANDLER = customProjectile -> PalladiumJSEvents.CUSTOM_PROJECTILE_TICK.post((EventJS)new ProjectileTickEventJS((CustomProjectile)((Object)customProjectile)));
        PalladiumEvents.REGISTER_PROPERTY.register(handler -> {
            if (handler.getEntity().m_9236_().f_46443_) {
                PalladiumJSEvents.CLIENT_REGISTER_PROPERTIES.post((EventJS)new RegisterPalladiumPropertyEventJS(handler.getEntity(), handler));
            } else {
                PalladiumJSEvents.REGISTER_PROPERTIES.post((EventJS)new RegisterPalladiumPropertyEventJS(handler.getEntity(), handler));
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        PalladiumClientEvents.REGISTER_ANIMATIONS.register(registry -> {
            PalladiumJSEvents.REGISTER_ANIMATIONS.post((EventJS)new RegisterAnimationsEventJS(registry));
            PalladiumJSEvents.REGISTER_GUI_OVERLAYS.post((EventJS)new RegisterGuiOverlaysEventJS());
        });
        PalladiumClientEvents.RENDER_POWER_SCREEN.register((screen, guiGraphics, mouseX, mouseY, partialTick, tab) -> PalladiumJSEvents.RENDER_POWER_SCREEN.post((EventJS)new RenderPowerScreenEventJS(screen, guiGraphics, mouseX, mouseY, partialTick, tab)));
        OverlayRegistry.registerOverlay((String)"palladium/kube_js_overlays", (OverlayRegistry.IngameOverlay)new RegisterGuiOverlaysEventJS.Overlay());
    }

    public void registerBindings(BindingsEvent event) {
        event.add("palladium", (Object)(event.getType() == ScriptType.CLIENT ? new PalladiumBindingClient() : new PalladiumBinding()));
        event.add("superpowerUtil", SuperpowerUtil.class);
        event.add("abilityUtil", AbilityUtil.class);
        if (event.getType() == ScriptType.CLIENT) {
            event.add("animationUtil", AnimationUtil.class);
            event.add("guiUtil", GuiUtilJS.class);
        }
    }

    public void registerTypeWrappers(ScriptType type, TypeWrappers typeWrappers) {
        if (type == ScriptType.CLIENT) {
            typeWrappers.registerSimple(Easing.class, o -> Easing.fromString(o.toString()));
            typeWrappers.registerSimple(PalladiumAnimation.PlayerModelPart.class, o -> PalladiumAnimation.PlayerModelPart.fromName(o.toString()));
            typeWrappers.registerSimple(PlayerSlot.class, o -> PlayerSlot.get(o.toString()));
        }
    }

    public void attachPlayerData(AttachedData<Player> event) {
        event.add("powers", (Object)new PowerHandlerJS((Player)event.getParent()));
    }

    public void attachLevelData(AttachedData<Level> event) {
        event.add("powers", (Object)new PowerManagerJS((Level)event.getParent()));
    }
}

