/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.threetag.palladium.condition.BuyableCondition;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionEnvironment;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.power.ability.AbilityConfiguration;
import net.threetag.palladium.util.icon.ExperienceIcon;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;

public class ExperienceLevelBuyableCondition
extends BuyableCondition {
    private final int xpLevel;
    private final boolean flatLevels;

    public ExperienceLevelBuyableCondition(int xpLevel, boolean flatLevels) {
        this.xpLevel = xpLevel;
        this.flatLevels = flatLevels;
    }

    @Override
    public AbilityConfiguration.UnlockData createData() {
        return new AbilityConfiguration.UnlockData(new ExperienceIcon(1, true), this.xpLevel, (Component)Component.m_237115_((String)("gui.palladium.powers.buy_ability.experience_level" + (this.xpLevel > 1 ? "_plural" : ""))));
    }

    @Override
    public boolean isAvailable(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.f_36078_ >= this.xpLevel;
        }
        return false;
    }

    @Override
    public boolean takeFromEntity(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.isAvailable(entity)) {
                if (this.flatLevels) {
                    player.m_6749_(-this.xpLevel);
                } else {
                    player.m_6756_(-this.getTotalXpForLevel(this.xpLevel));
                }
                return true;
            }
        }
        return false;
    }

    private int getTotalXpForLevel(int level) {
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.EXPERIENCE_LEVEL_BUYABLE.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<Integer> XP_LEVEL = new IntegerProperty("xp_level").configurable("Amount xp level that the player needs to spend");
        public static final PalladiumProperty<Boolean> FLAT_LEVELS = new BooleanProperty("flat_levels").configurable("Determines if the taken levels should be taken as-is, or be calculated appropriately to Minecraft logic.");

        public Serializer() {
            this.withProperty(XP_LEVEL, 3);
            this.withProperty(FLAT_LEVELS, true);
        }

        @Override
        public ConditionEnvironment getContextEnvironment() {
            return ConditionEnvironment.DATA;
        }

        @Override
        public Condition make(JsonObject json) {
            return new ExperienceLevelBuyableCondition(this.getProperty(json, XP_LEVEL), this.getProperty(json, FLAT_LEVELS));
        }

        @Override
        public String getDocumentationDescription() {
            return "A condition that makes the ability buyable for a certain amount of xp levels.";
        }
    }
}

