/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.data.forge;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

public class AddConditionRecipeWrapper {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<ICondition> conditions = new ArrayList<ICondition>();
        private FinishedRecipe recipe;

        public Builder addCondition(ICondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public Builder setRecipe(Consumer<Consumer<FinishedRecipe>> callable) {
            callable.accept(this::setRecipe);
            return this;
        }

        public Builder setRecipe(FinishedRecipe recipe) {
            this.recipe = recipe;
            return this;
        }

        public void build(Consumer<FinishedRecipe> consumer) {
            this.build(consumer, this.recipe.m_6445_());
        }

        public void build(Consumer<FinishedRecipe> consumer, String namespace, String path) {
            this.build(consumer, new ResourceLocation(namespace, path));
        }

        public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
            if (this.recipe == null) {
                throw new IllegalStateException("Invalid ConditionalRecipe builder, No recipe");
            }
            consumer.accept(new Finished(id, this.conditions, this.recipe));
        }
    }

    private static class Finished
    implements FinishedRecipe {
        private final ResourceLocation id;
        private List<ICondition> conditions = new ArrayList<ICondition>();
        private final FinishedRecipe recipe;

        public Finished(ResourceLocation id, List<ICondition> conditions, FinishedRecipe recipe) {
            this.id = id;
            this.conditions = conditions;
            this.recipe = recipe;
        }

        public void m_7917_(JsonObject jsonObject) {
            if (this.conditions != null && !this.conditions.isEmpty()) {
                JsonArray conds = new JsonArray();
                for (ICondition c : this.conditions) {
                    conds.add((JsonElement)CraftingHelper.serialize((ICondition)c));
                }
                jsonObject.add("conditions", (JsonElement)conds);
            }
            JsonObject recipeJson = this.recipe.m_125966_();
            for (Map.Entry entry : recipeJson.entrySet()) {
                jsonObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.recipe.m_6637_();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.recipe.m_5860_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.recipe.m_6448_();
        }
    }
}

