/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.entity;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.entity.PalladiumAttributes;
import net.threetag.palladium.sound.FlightSound;
import net.threetag.palladium.util.property.PalladiumProperties;
import net.threetag.palladiumcore.util.Platform;

public class FlightHandler {
    public static Object CACHED_SOUND = null;
    private final Player player;
    private Vec3 prevMovementDelta = null;
    private FlightType flightType = FlightType.NONE;
    private float flightSpeed = 1.0f;
    private boolean didFlew = false;
    public float flightBoost = 0.0f;
    private float prevFlightBoost = 0.0f;
    private int verticalHover = 0;
    private float levitation = 0.0f;
    private float prevLevitation = 0.0f;
    private float hovering = 0.0f;
    private float prevHovering = 0.0f;
    private Vec3 flightVector = Vec3.f_82478_;
    private Vec3 prevFlightVector = Vec3.f_82478_;
    private Vec3 prevLookAngle = Vec3.f_82478_;
    private float speed = 0.0f;
    private float prevSpeed = 0.0f;
    private float horizontalSpeed = 0.0f;
    private float prevHorizontalSpeed = 0.0f;

    public FlightHandler(Player player) {
        this.player = player;
    }

    public void tick() {
        this.prevMovementDelta = this.player.m_20184_();
        this.prevFlightBoost = this.flightBoost;
        this.prevLevitation = this.levitation;
        this.prevHovering = this.hovering;
        this.prevSpeed = this.speed;
        this.speed = (float)Math.sqrt(this.prevMovementDelta.f_82479_ * this.prevMovementDelta.f_82479_ + this.prevMovementDelta.f_82480_ * this.prevMovementDelta.f_82480_ + this.prevMovementDelta.f_82481_ * this.prevMovementDelta.f_82481_);
        this.prevHorizontalSpeed = this.horizontalSpeed;
        this.horizontalSpeed = (float)Math.sqrt(this.prevMovementDelta.f_82479_ * this.prevMovementDelta.f_82479_ + this.prevMovementDelta.f_82481_ * this.prevMovementDelta.f_82481_);
        this.prevLookAngle = this.player.m_20154_();
        this.prevFlightVector = this.flightVector;
        if (this.flightType.isNotNull() && (this.player.m_20096_() || this.player.m_21255_() || this.player.m_6069_() || this.player.m_21133_(this.flightType.getAttribute()) <= 0.0)) {
            this.flightType = FlightType.NONE;
        }
        if (this.flightType.isNotNull()) {
            if (this.player.m_20142_() && this.flightType == FlightType.NORMAL) {
                if (PalladiumProperties.FORWARD_KEY_DOWN.get((Entity)this.player).booleanValue() && this.flightBoost < 3.0f) {
                    this.flightBoost = Math.min(3.0f, this.flightBoost + 0.2f);
                } else if (!PalladiumProperties.FORWARD_KEY_DOWN.get((Entity)this.player).booleanValue() && this.flightBoost > 0.0f) {
                    this.flightBoost = Math.max(0.0f, this.flightBoost - 0.4f);
                }
                this.didFlew = true;
            } else if (PalladiumProperties.FORWARD_KEY_DOWN.get((Entity)this.player).booleanValue() && this.flightBoost < 1.0f) {
                this.flightBoost = Math.min(1.0f, this.flightBoost + 0.05f);
                this.didFlew = false;
            } else if (!PalladiumProperties.FORWARD_KEY_DOWN.get((Entity)this.player).booleanValue() && this.flightBoost > 0.0f) {
                this.flightBoost = Math.max(0.0f, this.flightBoost - 0.1f);
            }
            this.levitation = this.didFlew ? 0.0f : Mth.m_14036_((float)(this.horizontalSpeed * 2.0f), (float)0.0f, (float)1.0f);
        } else {
            this.hovering = 0.0f;
            this.levitation = 0.0f;
            this.flightBoost = 0.0f;
            this.didFlew = false;
        }
        if (this.flightBoost > 0.0f) {
            Vec3 sideVec;
            if (this.flightType.isNotNull()) {
                this.flightSpeed = (float)this.player.m_21133_(this.flightType.getAttribute());
            }
            if (this.hovering < 1.0f) {
                this.hovering = Math.min(1.0f, this.hovering + 0.1f);
            }
            Vec3 look = this.player.m_20154_().m_82490_((double)(this.flightBoost / 2.0f * this.flightSpeed));
            if (PalladiumProperties.LEFT_KEY_DOWN.get((Entity)this.player).booleanValue()) {
                sideVec = this.player.m_20154_().m_82524_((float)Math.toRadians(90.0)).m_82541_();
                look = look.m_82520_(sideVec.f_82479_, 0.0, sideVec.f_82481_);
            }
            if (PalladiumProperties.RIGHT_KEY_DOWN.get((Entity)this.player).booleanValue()) {
                sideVec = this.player.m_20154_().m_82524_((float)Math.toRadians(-90.0)).m_82541_();
                look = look.m_82520_(sideVec.f_82479_, 0.0, sideVec.f_82481_);
            }
            Vec3 diff = look.m_82546_(this.flightVector);
            double flexibility = (10.0 - this.player.m_21133_((Attribute)PalladiumAttributes.FLIGHT_FLEXIBILITY.get())) / 100.0;
            diff = diff.m_82553_() > flexibility ? diff.m_82490_(flexibility / diff.m_82553_()) : diff;
            this.flightVector = this.flightVector.m_82549_(diff);
            this.player.m_20256_(this.flightVector);
            this.player.f_19789_ = 0.0f;
            this.verticalHover = 0;
        } else if (this.flightType.isNotNull()) {
            this.didFlew = false;
            if (PalladiumProperties.JUMP_KEY_DOWN.get((Entity)this.player).booleanValue()) {
                if (this.verticalHover < 20) {
                    this.verticalHover = Mth.m_14045_((int)(this.verticalHover + 1), (int)-20, (int)20);
                }
            } else if (this.player.m_6047_()) {
                if (this.verticalHover > -20) {
                    this.verticalHover = Mth.m_14045_((int)(this.verticalHover - 1), (int)-20, (int)20);
                }
            } else if (this.verticalHover != 0) {
                this.verticalHover = Mth.m_14045_((int)(this.verticalHover + (this.verticalHover > 0 ? -1 : 1)), (int)-20, (int)20);
            }
            this.player.m_20256_(new Vec3(this.player.m_20184_().f_82479_, (double)this.verticalHover == 0.0 ? Math.sin((float)this.player.f_19797_ / 10.0f) / 100.0 : (double)this.verticalHover / 60.0, this.player.m_20184_().f_82481_));
            this.player.f_19789_ = 0.0f;
            this.flightVector = Vec3.f_82478_;
            if (this.hovering < 1.0f) {
                this.hovering = Math.min(1.0f, this.hovering + 0.1f);
            }
        } else {
            this.didFlew = false;
            this.verticalHover = 0;
            this.flightVector = Vec3.f_82478_;
            if (this.hovering > 0.0f) {
                this.hovering = Math.max(0.0f, this.hovering - 0.1f);
            }
        }
        if (this.flightBoost > 1.0f && this.prevFlightBoost <= 1.0f || this.flightBoost <= 1.0f && this.prevFlightBoost > 1.0f) {
            this.player.m_6210_();
            if (this.flightBoost > 1.0f && this.prevFlightBoost <= 1.0f && Platform.isClient()) {
                FlightHandler.startSound(this.player);
            }
        }
    }

    public Vec3 getPrevMovementDelta() {
        return this.prevMovementDelta;
    }

    public FlightType getFlightType() {
        return this.flightType;
    }

    public void setFlightType(FlightType flightType) {
        this.flightType = flightType;
        Attribute attribute = flightType.getAttribute();
        if (attribute != null) {
            this.flightSpeed = (float)this.player.m_21133_(attribute);
        }
        if (this.player.m_20142_()) {
            this.flightBoost = 1.0f;
        }
        this.player.m_6210_();
    }

    public float getFlightAnimation(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevFlightBoost, (float)this.flightBoost);
    }

    public float getLevitationAnimation(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevLevitation, (float)this.levitation);
    }

    public float getHoveringAnimation(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevHovering, (float)this.hovering);
    }

    public Vec3 getFlightVector(float partialTicks) {
        return this.prevFlightVector.m_165921_(this.flightVector, (double)partialTicks);
    }

    public Vec3 getLookAngle(float partialTicks) {
        return this.prevLookAngle.m_165921_(this.player.m_20154_(), (double)partialTicks);
    }

    public float getSpeed(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevSpeed, (float)this.speed);
    }

    public float getHorizontalSpeed(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevHorizontalSpeed, (float)this.horizontalSpeed);
    }

    public static FlightType getAvailableFlightType(LivingEntity entity) {
        if (entity.m_21204_().m_22171_((Attribute)PalladiumAttributes.FLIGHT_SPEED.get()) && entity.m_21133_((Attribute)PalladiumAttributes.FLIGHT_SPEED.get()) > 0.0) {
            return FlightType.NORMAL;
        }
        if (entity.m_21204_().m_22171_((Attribute)PalladiumAttributes.LEVITATION_SPEED.get()) && entity.m_21133_((Attribute)PalladiumAttributes.LEVITATION_SPEED.get()) > 0.0) {
            return FlightType.LEVITATION;
        }
        return FlightType.NONE;
    }

    public static FlightAnimationType getAnimationType(LivingEntity entity) {
        if (entity.m_21204_().m_22171_((Attribute)PalladiumAttributes.HEROIC_FLIGHT_TYPE.get()) && entity.m_21133_((Attribute)PalladiumAttributes.HEROIC_FLIGHT_TYPE.get()) > 0.0) {
            return FlightAnimationType.HEROIC;
        }
        return FlightAnimationType.NORMAL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void startSound(Player player) {
        if (player == Minecraft.m_91087_().f_91074_) {
            Object object = CACHED_SOUND;
            if (object instanceof FlightSound) {
                FlightSound sound = (FlightSound)((Object)object);
                sound.stop = true;
            }
            CACHED_SOUND = new FlightSound((LivingEntity)player, SoundEvents.f_11886_, player.m_5720_());
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)CACHED_SOUND);
        }
    }

    public static enum FlightType {
        NONE(() -> null),
        NORMAL((Supplier<Attribute>)PalladiumAttributes.FLIGHT_SPEED),
        LEVITATION((Supplier<Attribute>)PalladiumAttributes.LEVITATION_SPEED);

        private final Supplier<Attribute> attributeSupplier;

        private FlightType(Supplier<Attribute> attributeSupplier) {
            this.attributeSupplier = attributeSupplier;
        }

        public Attribute getAttribute() {
            return this.attributeSupplier.get();
        }

        public boolean isNotNull() {
            return this != NONE;
        }

        public boolean isNull() {
            return this == NONE;
        }

        public boolean isNormal() {
            return this == NORMAL;
        }

        public boolean isLevitation() {
            return this == LEVITATION;
        }
    }

    public static enum FlightAnimationType {
        NORMAL,
        HEROIC;

    }
}

