/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.entity;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.mixin.RangedAttributeAccessor;
import net.threetag.palladiumcore.event.LifecycleEvents;
import net.threetag.palladiumcore.event.LivingEntityEvents;
import net.threetag.palladiumcore.registry.DeferredRegister;
import net.threetag.palladiumcore.registry.EntityAttributeRegistry;
import net.threetag.palladiumcore.registry.RegistrySupplier;
import net.threetag.palladiumcore.util.Platform;

public class PalladiumAttributes {
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((String)"palladium", (ResourceKey)Registries.f_256728_);
    public static final RegistrySupplier<Attribute> FLIGHT_SPEED = ATTRIBUTES.register("flight_speed", () -> new RangedAttribute(PalladiumAttributes.name("flight_speed"), 0.0, 0.0, 32.0).m_22084_(true));
    public static final RegistrySupplier<Attribute> FLIGHT_FLEXIBILITY = ATTRIBUTES.register("flight_flexibility", () -> new RangedAttribute(PalladiumAttributes.name("flight_flexibility"), 0.0, 0.0, 10.0).m_22084_(true));
    public static final RegistrySupplier<Attribute> LEVITATION_SPEED = ATTRIBUTES.register("levitation_speed", () -> new RangedAttribute(PalladiumAttributes.name("levitation_speed"), 0.0, 0.0, 32.0).m_22084_(true));
    public static final RegistrySupplier<Attribute> HEROIC_FLIGHT_TYPE = ATTRIBUTES.register("heroic_flight_type", () -> new RangedAttribute(PalladiumAttributes.name("heroic_flight_type"), 0.0, 0.0, 1.0).m_22084_(true));
    public static final RegistrySupplier<Attribute> PUNCH_DAMAGE = ATTRIBUTES.register("punch_damage", () -> new RangedAttribute(PalladiumAttributes.name("punch_damage"), 0.0, 0.0, 2048.0));
    public static final RegistrySupplier<Attribute> JUMP_POWER = ATTRIBUTES.register("jump_power", () -> new RangedAttribute(PalladiumAttributes.name("jump_power"), 1.0, 0.0, 2048.0).m_22084_(true));
    public static final RegistrySupplier<Attribute> DESTROY_SPEED = ATTRIBUTES.register("destroy_speed", () -> new RangedAttribute(PalladiumAttributes.name("destroy_speed"), 1.0, 0.0, 2048.0).m_22084_(true));
    public static final RegistrySupplier<Attribute> FALL_RESISTANCE = ATTRIBUTES.register("fall_resistance", () -> new RangedAttribute(PalladiumAttributes.name("fall_resistance"), 1.0, 0.0, 100.0));
    public static final RegistrySupplier<Attribute> LEAPING = ATTRIBUTES.register("leaping", () -> new RangedAttribute(PalladiumAttributes.name("leaping"), 1.0, 0.0, 100.0));
    public static final UUID PUNCH_DAMAGE_MOD_UUID = UUID.fromString("b587e52f-6985-40f4-988e-48e3a7d3fdcb");

    public static void init() {
        EntityAttributeRegistry.registerModification(() -> EntityType.f_20532_, FLIGHT_SPEED);
        EntityAttributeRegistry.registerModification(() -> EntityType.f_20532_, FLIGHT_FLEXIBILITY);
        EntityAttributeRegistry.registerModification(() -> EntityType.f_20532_, LEVITATION_SPEED);
        EntityAttributeRegistry.registerModification(() -> EntityType.f_20532_, HEROIC_FLIGHT_TYPE);
        EntityAttributeRegistry.registerModification(() -> EntityType.f_20532_, PUNCH_DAMAGE);
        EntityAttributeRegistry.registerModification(() -> EntityType.f_20532_, JUMP_POWER);
        EntityAttributeRegistry.registerModification(() -> EntityType.f_20532_, DESTROY_SPEED);
        EntityAttributeRegistry.registerModification(() -> EntityType.f_20532_, FALL_RESISTANCE);
        EntityAttributeRegistry.registerModification(() -> EntityType.f_20532_, LEAPING);
        PalladiumAttributes.events();
        if (!Platform.isModLoaded((String)"attributefix")) {
            LifecycleEvents.SETUP.register(() -> {
                Attribute patt4214$temp;
                RangedAttributeAccessor accessor;
                Attribute patt4042$temp = Attributes.f_22284_;
                if (patt4042$temp instanceof RangedAttributeAccessor) {
                    accessor = (RangedAttributeAccessor)patt4042$temp;
                    accessor.palladium_setMaxValue(1024.0);
                }
                if ((patt4214$temp = Attributes.f_22282_) instanceof RangedAttributeAccessor) {
                    accessor = (RangedAttributeAccessor)patt4214$temp;
                    accessor.palladium_setMaxValue(1024.0);
                }
            });
        }
    }

    private static void events() {
        LivingEntityEvents.TICK.register(entity -> {
            if (entity.m_21204_().m_22171_((Attribute)PUNCH_DAMAGE.get())) {
                double punchDmg = entity.m_21133_((Attribute)PUNCH_DAMAGE.get());
                AttributeInstance attackDmg = Objects.requireNonNull(entity.m_21051_(Attributes.f_22281_));
                AttributeModifier currentMod = attackDmg.m_22111_(PUNCH_DAMAGE_MOD_UUID);
                if (currentMod != null && currentMod.m_22218_() != punchDmg) {
                    attackDmg.m_22120_(PUNCH_DAMAGE_MOD_UUID);
                }
                if (currentMod == null && punchDmg > 0.0 || currentMod != null && currentMod.m_22218_() != punchDmg) {
                    attackDmg.m_22118_(new AttributeModifier(PUNCH_DAMAGE_MOD_UUID, "Punch Damage", punchDmg, AttributeModifier.Operation.ADDITION));
                }
            }
        });
        LivingEntityEvents.JUMP.register(entity -> {
            double mul;
            if (entity.m_21204_().m_22171_((Attribute)LEAPING.get()) && (mul = entity.m_21133_((Attribute)LEAPING.get())) != 1.0) {
                Vec3 vec3 = entity.m_20184_();
                vec3 = vec3.m_82520_(vec3.f_82479_ * mul, 0.0, vec3.f_82481_ * mul);
                entity.m_20256_(vec3);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
                }
            }
        });
    }

    public static String name(String name) {
        return "attribute.name.generic.palladium." + name;
    }
}

