/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.client.renderer.trail.CompoundTrailRenderer;
import net.threetag.palladium.client.renderer.trail.TrailRenderer;
import net.threetag.palladium.client.renderer.trail.TrailRendererManager;
import net.threetag.palladium.entity.CustomProjectile;
import net.threetag.palladium.entity.TrailSegmentEntity;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.power.ability.TrailAbility;

public class TrailHandler {
    private final Entity entity;
    private Map<TrailRenderer<?>, List<TrailSegmentEntity<?>>> trails = new HashMap();

    public TrailHandler(Entity entity) {
        this.entity = entity;
    }

    public void tick() {
        List<TrailRenderer<?>> active = TrailHandler.getTrailRenderersFor(this.entity);
        for (TrailRenderer<?> renderer : active) {
            this.trails.putIfAbsent(renderer, new LinkedList());
        }
        HashMap toChange = new HashMap(this.trails);
        for (Map.Entry<TrailRenderer<?>, List<TrailSegmentEntity<?>>> entry : this.trails.entrySet()) {
            TrailRenderer<?> renderer = entry.getKey();
            List<TrailSegmentEntity<Object>> trails = entry.getValue();
            if (!trails.isEmpty()) {
                TrailSegmentEntity<?> last;
                if (active.contains(renderer) && (last = trails.get(trails.size() - 1)).m_20182_().m_82554_(this.entity.m_20182_()) >= (double)(this.entity.m_20205_() * renderer.getSpacing())) {
                    trails.add(this.spawnEntity(renderer));
                }
                trails = trails.stream().filter(LivingEntity::m_6084_).collect(Collectors.toList());
            } else if (active.contains(renderer) && this.isMoving()) {
                trails.add(this.spawnEntity(renderer));
            }
            if (!active.contains(renderer) && trails.isEmpty()) {
                toChange.remove(renderer);
                continue;
            }
            toChange.put(renderer, trails);
        }
        this.trails = toChange;
    }

    private TrailSegmentEntity<?> spawnEntity(TrailRenderer<?> trailRenderer) {
        TrailSegmentEntity entity = new TrailSegmentEntity(this.entity, trailRenderer);
        Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_104627_(0, entity);
        return entity;
    }

    public Map<TrailRenderer<?>, List<TrailSegmentEntity<?>>> getTrails() {
        return this.trails;
    }

    private boolean isMoving() {
        if (this.entity instanceof LivingEntity) {
            return this.entity.f_19854_ != this.entity.m_20185_() || this.entity.f_19855_ != this.entity.m_20186_() || this.entity.f_19856_ != this.entity.m_20189_();
        }
        return this.entity.m_20184_().m_82553_() != 0.0;
    }

    public static List<TrailRenderer<?>> getTrailRenderersFor(Entity entity) {
        ArrayList renderers = new ArrayList();
        if (!entity.m_6084_()) {
            return renderers;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            for (TrailRenderer renderer : AbilityUtil.getEnabledEntries(living, (Ability)Abilities.TRAIL.get()).stream().map(e -> TrailRendererManager.INSTANCE.getRenderer(e.getProperty(TrailAbility.TRAIL_RENDERER_ID))).filter(Objects::nonNull).distinct().toList()) {
                TrailHandler.addTrailToList(renderer, renderers);
            }
        }
        if (entity instanceof CustomProjectile) {
            CustomProjectile projectile = (CustomProjectile)entity;
            for (CustomProjectile.Appearance appearance : projectile.appearances) {
                if (!(appearance instanceof CustomProjectile.TrailAppearance)) continue;
                CustomProjectile.TrailAppearance trailAppearance = (CustomProjectile.TrailAppearance)appearance;
                for (ResourceLocation trailId : trailAppearance.trails) {
                    TrailRenderer<?> trailRenderer = TrailRendererManager.INSTANCE.getRenderer(trailId);
                    if (trailRenderer == null || renderers.contains(trailRenderer)) continue;
                    renderers.add(trailRenderer);
                }
            }
        }
        return renderers;
    }

    private static void addTrailToList(TrailRenderer<?> trailRenderer, List<TrailRenderer<?>> trailRendererList) {
        if (trailRenderer instanceof CompoundTrailRenderer) {
            CompoundTrailRenderer compound = (CompoundTrailRenderer)trailRenderer;
            for (TrailRenderer<?> renderer : compound.getTrailRenderers()) {
                TrailHandler.addTrailToList(renderer, trailRendererList);
            }
        } else if (!trailRendererList.contains(trailRenderer)) {
            trailRendererList.add(trailRenderer);
        }
    }
}

