/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.power.ability.IntangibilityAbility;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public class BlockStateBaseMixin {
    @Inject(method={"getCollisionShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, at={@At(value="RETURN")}, cancellable=true)
    private void getCollisionShape(BlockGetter level, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> cir) {
        EntityCollisionContext ctx;
        Entity entity;
        VoxelShape blockShape = (VoxelShape)cir.getReturnValue();
        if (!blockShape.m_83281_() && context instanceof EntityCollisionContext && (entity = (ctx = (EntityCollisionContext)context).m_193113_()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            boolean isAbove = this.isAbove((Entity)entity2, blockShape, pos, false);
            for (AbilityInstance entry : AbilityUtil.getEnabledEntries(entity2, (Ability)Abilities.INTANGIBILITY.get())) {
                if (isAbove && !entry.getProperty(IntangibilityAbility.VERTICAL).booleanValue() || !IntangibilityAbility.canGoThrough(entry, level.m_8055_(pos))) continue;
                cir.setReturnValue((Object)Shapes.m_83040_());
                return;
            }
        }
    }

    @Unique
    private boolean isAbove(Entity entity, VoxelShape shape, BlockPos pos, boolean defaultValue) {
        return entity.m_20186_() > (double)pos.m_123342_() + shape.m_83297_(Direction.Axis.Y) - (entity.m_20096_() ? 0.503125 : 0.0015);
    }

    @Inject(method={"entityInside"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventCollisionWhenPhasing(Level level, BlockPos pos, Entity entity, CallbackInfo ci) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            for (AbilityInstance entry : AbilityUtil.getEnabledEntries(living, (Ability)Abilities.INTANGIBILITY.get())) {
                if (!IntangibilityAbility.canGoThrough(entry, level.m_8055_(pos))) continue;
                ci.cancel();
                return;
            }
        }
    }
}

