/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.client.screen.AccessoryScreen;
import net.threetag.palladium.network.PalladiumNetwork;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageS2C;
import net.threetag.palladiumcore.network.MessageType;

public class SyncAccessoriesMessage
extends MessageS2C {
    public int entityId;
    public Map<AccessorySlot, Collection<Accessory>> accessories;

    public SyncAccessoriesMessage(int entityId, Map<AccessorySlot, Collection<Accessory>> accessories) {
        this.entityId = entityId;
        this.accessories = accessories;
    }

    public SyncAccessoriesMessage(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        int amount = buf.readInt();
        this.accessories = new HashMap<AccessorySlot, Collection<Accessory>>();
        for (int i = 0; i < amount; ++i) {
            AccessorySlot slot = AccessorySlot.getSlotByName(buf.m_130281_());
            ArrayList<Accessory> accessories1 = new ArrayList<Accessory>();
            int slotAmount = buf.readInt();
            for (int j = 0; j < slotAmount; ++j) {
                Accessory accessory = (Accessory)Accessory.REGISTRY.get(buf.m_130281_());
                if (accessory == null) continue;
                accessories1.add(accessory);
            }
            this.accessories.put(slot, accessories1);
        }
    }

    public MessageType getType() {
        return PalladiumNetwork.SYNC_ACCESSORIES;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.accessories.size());
        this.accessories.forEach((slot, accessories) -> {
            buf.m_130085_(slot.getName());
            buf.writeInt(accessories.size());
            for (Accessory accessory : accessories) {
                buf.m_130085_(Accessory.REGISTRY.getKey((Object)accessory));
            }
        });
    }

    public void handle(MessageContext context) {
        this.handleClient();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient() {
        Entity entity = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_6815_(this.entityId);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Accessory.getPlayerData(player).ifPresent(data -> {
                data.clear(player);
                this.accessories.forEach((slot, accessories) -> {
                    for (Accessory accessory : accessories) {
                        data.enable((AccessorySlot)slot, accessory, player);
                    }
                });
                if (Minecraft.m_91087_().f_91080_ instanceof AccessoryScreen) {
                    ((AccessoryScreen)Minecraft.m_91087_().f_91080_).accessoryList.refreshList();
                }
            });
        }
    }
}

