/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.threetag.palladium.entity.FlightHandler;
import net.threetag.palladium.entity.PalladiumPlayerExtension;
import net.threetag.palladium.network.PalladiumNetwork;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageS2C;
import net.threetag.palladiumcore.network.MessageType;
import org.jetbrains.annotations.NotNull;

public class SyncFlightStateMessage
extends MessageS2C {
    private final int entityId;
    private final boolean flying;

    public SyncFlightStateMessage(int entityId, boolean flying) {
        this.entityId = entityId;
        this.flying = flying;
    }

    public SyncFlightStateMessage(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.flying = buf.readBoolean();
    }

    @NotNull
    public MessageType getType() {
        return PalladiumNetwork.SYNC_FLYING_STATE;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeBoolean(this.flying);
    }

    public void handle(MessageContext context) {
        Entity entity = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_6815_(this.entityId);
        if (entity instanceof PalladiumPlayerExtension) {
            PalladiumPlayerExtension extension = (PalladiumPlayerExtension)entity;
            FlightHandler flight = extension.palladium$getFlightHandler();
            if (this.flying) {
                FlightHandler.FlightType flightType = FlightHandler.getAvailableFlightType((LivingEntity)((Player)entity));
                if (flightType.isNotNull()) {
                    flight.setFlightType(flightType);
                }
            } else {
                flight.setFlightType(FlightHandler.FlightType.NONE);
            }
            ((Player)entity).m_150110_().f_35935_ = false;
        }
    }
}

