/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerManager;

public class PowerUtil {
    public static Collection<Power> getPowers(LivingEntity entity) {
        ArrayList<Power> powers = new ArrayList<Power>();
        PowerManager.getPowerHandler(entity).ifPresent(powerHandler -> powers.addAll(powerHandler.getPowerHolders().values().stream().map(IPowerHolder::getPower).toList()));
        return powers;
    }

    public static Collection<ResourceLocation> getPowerIds(LivingEntity entity) {
        ArrayList<ResourceLocation> powers = new ArrayList<ResourceLocation>();
        PowerManager.getPowerHandler(entity).ifPresent(powerHandler -> powers.addAll(powerHandler.getPowerHolders().values().stream().map(h -> h.getPower().getId()).toList()));
        return powers;
    }

    public static Collection<Power> getPowersForNamespace(LivingEntity entity, String namespace) {
        ArrayList<Power> powers = new ArrayList<Power>();
        PowerManager.getPowerHandler(entity).ifPresent(powerHandler -> powers.addAll(powerHandler.getPowerHolders().values().stream().map(IPowerHolder::getPower).filter(p -> p.getId().m_135827_().equals(namespace)).toList()));
        return powers;
    }

    public static Collection<ResourceLocation> getPowerIdsForNamespace(LivingEntity entity, String namespace) {
        ArrayList<ResourceLocation> powers = new ArrayList<ResourceLocation>();
        PowerManager.getPowerHandler(entity).ifPresent(powerHandler -> powers.addAll(powerHandler.getPowerHolders().values().stream().map(h -> h.getPower().getId()).filter(id -> id.m_135827_().equals(namespace)).toList()));
        return powers;
    }
}

