/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class AbilityDescription {
    private final Component lockedDescription;
    private final Component unlockedDescription;

    public AbilityDescription(Component lockedDescription, Component unlockedDescription) {
        this.lockedDescription = lockedDescription;
        this.unlockedDescription = unlockedDescription;
    }

    public AbilityDescription(Component description) {
        this.lockedDescription = this.unlockedDescription = description;
    }

    public Component get(boolean unlocked) {
        return unlocked ? this.unlockedDescription : this.lockedDescription;
    }

    public static AbilityDescription fromJson(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return new AbilityDescription((Component)Component.Serializer.m_130691_((JsonElement)jsonElement));
        }
        if (jsonElement.isJsonObject()) {
            JsonObject obj = jsonElement.getAsJsonObject();
            if (obj.has("locked") && obj.has("unlocked")) {
                return new AbilityDescription((Component)Component.Serializer.m_130691_((JsonElement)obj.get("locked")), (Component)Component.Serializer.m_130691_((JsonElement)obj.get("unlocked")));
            }
            return new AbilityDescription((Component)Component.Serializer.m_130691_((JsonElement)jsonElement));
        }
        return new AbilityDescription((Component)Component.Serializer.m_130691_((JsonElement)jsonElement));
    }

    public JsonElement toJson() {
        if (this.lockedDescription == this.unlockedDescription) {
            return Component.Serializer.m_130716_((Component)this.lockedDescription);
        }
        JsonObject json = new JsonObject();
        json.add("locked", Component.Serializer.m_130716_((Component)this.lockedDescription));
        json.add("unlocked", Component.Serializer.m_130716_((Component)this.unlockedDescription));
        return json;
    }

    public static AbilityDescription fromNbt(CompoundTag nbt) {
        String unlocked;
        String locked = nbt.m_128461_("Locked");
        if (locked.equals(unlocked = nbt.m_128461_("Unlocked"))) {
            return new AbilityDescription((Component)Component.Serializer.m_130701_((String)locked));
        }
        return new AbilityDescription((Component)Component.Serializer.m_130701_((String)locked), (Component)Component.Serializer.m_130701_((String)unlocked));
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Locked", Component.Serializer.m_130703_((Component)this.lockedDescription));
        nbt.m_128359_("Unlocked", Component.Serializer.m_130703_((Component)this.unlockedDescription));
        return nbt;
    }

    public static AbilityDescription fromBuffer(FriendlyByteBuf buf) {
        boolean same = buf.readBoolean();
        if (same) {
            return new AbilityDescription(buf.m_130238_());
        }
        return new AbilityDescription(buf.m_130238_(), buf.m_130238_());
    }

    public void toBuffer(FriendlyByteBuf buf) {
        buf.writeBoolean(this.lockedDescription == this.unlockedDescription);
        buf.m_130083_(this.lockedDescription);
        if (this.lockedDescription != this.unlockedDescription) {
            buf.m_130083_(this.unlockedDescription);
        }
    }
}

