/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.Comparator;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.AttributeProperty;
import net.threetag.palladium.util.property.DoubleProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.UUIDProperty;

public class AttributeModifierAbility
extends Ability {
    public static final PalladiumProperty<Attribute> ATTRIBUTE = new AttributeProperty("attribute").configurable("Determines which attribute should be modified. Possible attributes: " + AttributeModifierAbility.getAttributeList());
    public static final PalladiumProperty<Double> AMOUNT = new DoubleProperty("amount").configurable("The amount for the giving attribute modifier");
    public static final PalladiumProperty<Integer> OPERATION = new IntegerProperty("operation").configurable("The operation for the giving attribute modifier (More: https://minecraft.gamepedia.com/Attribute#Operations)");
    public static final PalladiumProperty<UUID> UUID = new UUIDProperty("uuid").configurable("Sets the unique identifier for this attribute modifier. If not specified it will generate a random one");

    public AttributeModifierAbility() {
        this.withProperty(ICON, new ItemIcon((ItemLike)Items.f_42469_));
        this.withProperty(ATTRIBUTE, Attributes.f_22284_);
        this.withProperty(AMOUNT, 1.0);
        this.withProperty(OPERATION, 0);
        this.withProperty(UUID, java.util.UUID.fromString("498be4fb-af04-42f2-8948-e6ccdc0d99e1"));
    }

    @Override
    public void tick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled) {
            Attribute attribute = entry.getProperty(ATTRIBUTE);
            AttributeInstance instance = entity.m_21051_(attribute);
            if (instance == null || entity.m_9236_().f_46443_) {
                return;
            }
            UUID uuid = entry.getProperty(UUID);
            AttributeModifier modifier = instance.m_22111_(uuid);
            if (modifier != null && (modifier.m_22218_() != entry.getProperty(AMOUNT).doubleValue() || modifier.m_22217_().m_22235_() != entry.getProperty(OPERATION).intValue())) {
                instance.m_22120_(uuid);
                modifier = null;
            }
            if (modifier == null) {
                modifier = new AttributeModifier(uuid, entry.getConfiguration().getDisplayName().getString(), entry.getProperty(AMOUNT).doubleValue(), AttributeModifier.Operation.m_22236_((int)entry.getProperty(OPERATION)));
                instance.m_22118_(modifier);
            }
        } else {
            this.lastTick(entity, entry, holder, false);
        }
    }

    @Override
    public void lastTick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (entity.m_21051_(entry.getProperty(ATTRIBUTE)) != null && entity.m_21051_(entry.getProperty(ATTRIBUTE)).m_22111_(entry.getProperty(UUID)) != null) {
            entity.m_21051_(entry.getProperty(ATTRIBUTE)).m_22120_(entry.getProperty(UUID));
        }
    }

    public static String getAttributeList() {
        return BuiltInRegistries.f_256951_.m_6566_().stream().map(ResourceLocation::toString).sorted(Comparator.naturalOrder()).collect(Collectors.joining(", "));
    }

    @Override
    public String getDocumentationDescription() {
        return "Adds an attribute modifier to the entity while the ability is enabled.";
    }
}

