/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.TagKeyListProperty;

public class DamageImmunityAbility
extends Ability {
    public static final PalladiumProperty<List<TagKey<DamageType>>> DAMAGE_SOURCES = new TagKeyListProperty("damage_sources", Registries.f_268580_).configurable("Determines which damage sources have no effect on the entity based on a tag. Minecraft's builtin damage source tags: " + Arrays.toString(DamageImmunityAbility.getExampleTags().stream().map(t -> t.f_203868_().toString()).toArray()));

    public DamageImmunityAbility() {
        this.withProperty(ICON, new ItemIcon((ItemLike)Items.f_42589_));
        this.withProperty(DAMAGE_SOURCES, Arrays.asList(DamageTypeTags.f_268725_, DamageTypeTags.f_268549_));
    }

    public static boolean isImmuneAgainst(AbilityInstance entry, DamageSource source) {
        if (!entry.isEnabled()) {
            return false;
        }
        for (TagKey<DamageType> tag : entry.getProperty(DAMAGE_SOURCES)) {
            if (!source.m_269533_(tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDocumentationDescription() {
        return "Makes the entity immune against certain damage source tags.";
    }

    public static List<TagKey<?>> getExampleTags() {
        Field[] allFields;
        ArrayList list = new ArrayList();
        for (Field field : allFields = DamageTypeTags.class.getDeclaredFields()) {
            try {
                Object object = field.get(null);
                if (!(object instanceof TagKey)) continue;
                TagKey tag = (TagKey)object;
                list.add(tag);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }
}

