/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;
import net.threetag.palladium.util.property.EntityPropertyHandler;
import net.threetag.palladium.util.property.IntegerProperty;
import org.jetbrains.annotations.Nullable;

public abstract class EntityDependentInteger {
    public abstract int get(Entity var1);

    public boolean isDynamic() {
        return true;
    }

    public static EntityDependentInteger staticValue(int value) {
        return new Static(value);
    }

    public static EntityDependentInteger score(String objectiveName, int fallbackValue) {
        return new Score(objectiveName, fallbackValue);
    }

    public static EntityDependentInteger palladiumProperty(String propertyName, int fallbackValue) {
        return new PalladiumProperty(propertyName, fallbackValue);
    }

    public static EntityDependentInteger fromJson(JsonElement jsonElement, String memberName) {
        if (jsonElement.isJsonPrimitive()) {
            return EntityDependentInteger.staticValue(GsonHelper.m_13897_((JsonElement)jsonElement, (String)memberName));
        }
        if (jsonElement.isJsonObject()) {
            JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement, (String)memberName);
            String type = GsonHelper.m_13906_((JsonObject)json, (String)"type");
            if (type.equalsIgnoreCase("score")) {
                return EntityDependentInteger.score(GsonHelper.m_13906_((JsonObject)json, (String)"objective"), GsonHelper.m_13824_((JsonObject)json, (String)"fallback", (int)0));
            }
            if (type.equalsIgnoreCase("palladium_property")) {
                return EntityDependentInteger.palladiumProperty(GsonHelper.m_13906_((JsonObject)json, (String)"property"), GsonHelper.m_13824_((JsonObject)json, (String)"fallback", (int)0));
            }
            throw new JsonParseException("Unknown type " + type + ", must be 'score' or 'palladium_property'");
        }
        throw new JsonParseException(memberName + " must be either a primitive integer, or a JsonObject");
    }

    public abstract JsonElement toJson();

    @Nullable
    public static EntityDependentInteger fromNBT(Tag tag) {
        if (tag instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            return EntityDependentInteger.staticValue(intTag.m_7047_());
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            String type = compoundTag.m_128461_("Type");
            if (type.equalsIgnoreCase("score")) {
                return EntityDependentInteger.score(compoundTag.m_128461_("Objective"), compoundTag.m_128451_("Fallback"));
            }
            if (type.equalsIgnoreCase("palladium_property")) {
                return EntityDependentInteger.palladiumProperty(compoundTag.m_128461_("Property"), compoundTag.m_128451_("Fallback"));
            }
        }
        return null;
    }

    public abstract Tag toNBT();

    public static EntityDependentInteger fromBuffer(FriendlyByteBuf buf) {
        int type = buf.readInt();
        if (type == 0) {
            return EntityDependentInteger.staticValue(buf.readInt());
        }
        if (type == 1) {
            return EntityDependentInteger.score(buf.m_130277_(), buf.readInt());
        }
        return EntityDependentInteger.palladiumProperty(buf.m_130277_(), buf.readInt());
    }

    public abstract void toBuffer(FriendlyByteBuf var1);

    private static class Static
    extends EntityDependentInteger {
        private final int value;

        public Static(int value) {
            this.value = value;
        }

        @Override
        public int get(Entity entity) {
            return this.value;
        }

        @Override
        public boolean isDynamic() {
            return false;
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive((Number)this.value);
        }

        @Override
        public Tag toNBT() {
            return IntTag.m_128679_((int)this.value);
        }

        @Override
        public void toBuffer(FriendlyByteBuf buf) {
            buf.writeInt(0);
            buf.writeInt(this.value);
        }
    }

    private static class Score
    extends EntityDependentInteger {
        private final String objectiveName;
        private final int fallbackValue;

        public Score(String objectiveName, int fallbackValue) {
            this.objectiveName = objectiveName;
            this.fallbackValue = fallbackValue;
        }

        @Override
        public int get(Entity entity) {
            Scoreboard scoreboard = entity.m_9236_().m_6188_();
            Objective objective = scoreboard.m_83477_(this.objectiveName);
            if (objective != null) {
                Map scores = scoreboard.m_83483_(entity.m_6302_());
                return scores.containsKey(objective) ? ((net.minecraft.world.scores.Score)scores.get(objective)).m_83400_() : this.fallbackValue;
            }
            return this.fallbackValue;
        }

        @Override
        public JsonElement toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("type", "score");
            json.addProperty("objective", this.objectiveName);
            if (this.fallbackValue != 0) {
                json.addProperty("fallback", (Number)this.fallbackValue);
            }
            return json;
        }

        @Override
        public Tag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Type", "score");
            tag.m_128359_("Objective", this.objectiveName);
            tag.m_128405_("Fallback", this.fallbackValue);
            return tag;
        }

        @Override
        public void toBuffer(FriendlyByteBuf buf) {
            buf.writeInt(1);
            buf.m_130070_(this.objectiveName);
            buf.writeInt(this.fallbackValue);
        }
    }

    private static class PalladiumProperty
    extends EntityDependentInteger {
        private final String propertyName;
        private final int fallbackValue;

        public PalladiumProperty(String propertyName, int fallbackValue) {
            this.propertyName = propertyName;
            this.fallbackValue = fallbackValue;
        }

        @Override
        public int get(Entity entity) {
            EntityPropertyHandler handler;
            net.threetag.palladium.util.property.PalladiumProperty<?> property;
            Optional<EntityPropertyHandler> opt = EntityPropertyHandler.getHandler(entity);
            if (opt.isPresent() && (property = (handler = opt.get()).getPropertyByName(this.propertyName)) instanceof IntegerProperty) {
                IntegerProperty integerProperty = (IntegerProperty)property;
                Integer result = handler.get(integerProperty);
                return result == null ? this.fallbackValue : result;
            }
            return this.fallbackValue;
        }

        @Override
        public JsonElement toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("type", "palladium_property");
            json.addProperty("property", this.propertyName);
            if (this.fallbackValue != 0) {
                json.addProperty("fallback", (Number)this.fallbackValue);
            }
            return json;
        }

        @Override
        public Tag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Type", "palladium_property");
            tag.m_128359_("Property", this.propertyName);
            tag.m_128405_("Fallback", this.fallbackValue);
            return tag;
        }

        @Override
        public void toBuffer(FriendlyByteBuf buf) {
            buf.writeInt(2);
            buf.m_130070_(this.propertyName);
            buf.writeInt(this.fallbackValue);
        }
    }
}

