/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.threetag.palladium.compat.curiostinkets.CuriosTrinketsSlotInv;
import net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerSlot {
    private static final Map<EquipmentSlot, PlayerSlot> EQUIPMENT_SLOTS = new HashMap<EquipmentSlot, PlayerSlot>();
    private static final Map<String, PlayerSlot> SLOTS = new HashMap<String, PlayerSlot>();

    @NotNull
    public static PlayerSlot get(EquipmentSlot slot) {
        return Objects.requireNonNull(PlayerSlot.get(slot.m_20751_()));
    }

    @Nullable
    public static PlayerSlot get(String name) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (!slot.m_20751_().equalsIgnoreCase(name)) continue;
            return EQUIPMENT_SLOTS.computeIfAbsent(slot, EquipmentPlayerSlot::new);
        }
        if (name.startsWith("curios:")) {
            return SLOTS.computeIfAbsent(name, n -> new CurioTrinketSlot(true, name.substring("curios:".length())));
        }
        if (name.startsWith("trinkets:")) {
            return SLOTS.computeIfAbsent(name, n -> new CurioTrinketSlot(false, name.substring("trinkets:".length())));
        }
        return null;
    }

    public abstract List<ItemStack> getItems(LivingEntity var1);

    public abstract void setItem(LivingEntity var1, ItemStack var2);

    public abstract void clear(LivingEntity var1);

    public abstract Type getType();

    @Nullable
    public EquipmentSlot getEquipmentSlot() {
        return null;
    }

    private static class CurioTrinketSlot
    extends PlayerSlot {
        private final boolean curios;
        private final String slot;

        public CurioTrinketSlot(boolean curios, String slot) {
            this.curios = curios;
            this.slot = slot;
        }

        @Override
        public List<ItemStack> getItems(LivingEntity entity) {
            return CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, this.slot);
        }

        @Override
        public void setItem(LivingEntity entity, ItemStack stack) {
            CuriosTrinketsUtil.getInstance().getSlot(entity, this.slot).setStackInSlot(0, stack);
        }

        @Override
        public void clear(LivingEntity entity) {
            CuriosTrinketsSlotInv inv = CuriosTrinketsUtil.getInstance().getSlot(entity, this.slot);
            for (int i = 0; i < inv.getSlots(); ++i) {
                inv.setStackInSlot(i, ItemStack.f_41583_);
            }
        }

        @Override
        public Type getType() {
            return Type.CURIOS_TRINKET;
        }

        public String toString() {
            return (this.curios ? "curios:" : "trinkets:") + this.slot;
        }
    }

    public static enum Type {
        EQUIPMENT_SLOT,
        CURIOS_TRINKET;

    }

    private static class EquipmentPlayerSlot
    extends PlayerSlot {
        private final EquipmentSlot slot;

        public EquipmentPlayerSlot(EquipmentSlot slot) {
            this.slot = slot;
        }

        @Override
        public List<ItemStack> getItems(LivingEntity entity) {
            return Collections.singletonList(entity.m_6844_(this.slot));
        }

        @Override
        public void setItem(LivingEntity entity, ItemStack stack) {
            entity.m_8061_(this.slot, stack);
        }

        @Override
        public void clear(LivingEntity entity) {
            entity.m_8061_(this.slot, ItemStack.f_41583_);
        }

        @Override
        @Nullable
        public EquipmentSlot getEquipmentSlot() {
            return this.slot;
        }

        @Override
        public Type getType() {
            return Type.EQUIPMENT_SLOT;
        }

        public String toString() {
            return this.slot.m_20751_();
        }
    }
}

