/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class RegistrySynonymsHandler {
    private static final Map<ResourceKey<?>, List<Synonym>> SYNONYMS = new HashMap();

    public static void register(ResourceKey<?> registry, ResourceLocation id1, ResourceLocation id2) {
        SYNONYMS.computeIfAbsent(registry, r -> new ArrayList()).add(new Synonym(id1, id2));
    }

    public static ResourceLocation getReplacement(Registry<?> registry, ResourceLocation id) {
        List<Synonym> list;
        if (!registry.m_7804_(id) && (list = SYNONYMS.get(registry.m_123023_())) != null) {
            for (Synonym synonym : list) {
                if (synonym.id1.equals((Object)id) && registry.m_7804_(synonym.id2)) {
                    return synonym.id2;
                }
                if (!synonym.id2.equals((Object)id) || !registry.m_7804_(synonym.id1)) continue;
                return synonym.id1;
            }
        }
        return id;
    }

    static {
        RegistrySynonymsHandler.register(Registries.f_256728_, new ResourceLocation("porting_lib:step_height_addition"), new ResourceLocation("forge:step_height_addition"));
        RegistrySynonymsHandler.register(Registries.f_256728_, new ResourceLocation("porting_lib:entity_gravity"), new ResourceLocation("forge:entity_gravity"));
        RegistrySynonymsHandler.register(Registries.f_256728_, new ResourceLocation("porting_lib:swim_speed"), new ResourceLocation("forge:swim_speed"));
        RegistrySynonymsHandler.register(Registries.f_256728_, new ResourceLocation("porting_lib:reach_distance"), new ResourceLocation("forge:block_reach"));
        RegistrySynonymsHandler.register(Registries.f_256728_, new ResourceLocation("porting_lib:attack_range"), new ResourceLocation("forge:entity_reach"));
        RegistrySynonymsHandler.register(Registries.f_256728_, new ResourceLocation("reach-entity-attributes:reach"), new ResourceLocation("forge:block_reach"));
        RegistrySynonymsHandler.register(Registries.f_256728_, new ResourceLocation("reach-entity-attributes:attack_range"), new ResourceLocation("forge:entity_reach"));
        RegistrySynonymsHandler.register(Registries.f_256728_, new ResourceLocation("porting_lib:reach_distance"), new ResourceLocation("reach-entity-attributes:reach"));
        RegistrySynonymsHandler.register(Registries.f_256728_, new ResourceLocation("porting_lib:attack_range"), new ResourceLocation("reach-entity-attributes:attack_range"));
    }

    static class Synonym {
        private final ResourceLocation id1;
        private final ResourceLocation id2;

        public Synonym(ResourceLocation id1, ResourceLocation id2) {
            this.id1 = id1;
            this.id2 = id2;
        }
    }
}

