/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.icon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.IconSerializer;
import net.threetag.palladium.util.icon.IconSerializers;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.icon.TexturedIcon;
import org.jetbrains.annotations.NotNull;

public class CompoundIcon
implements IIcon {
    private final LinkedList<IIcon> icons = new LinkedList();

    @Override
    public void draw(Minecraft mc, GuiGraphics guiGraphics, DataContext context, int x, int y, int width, int height) {
        for (IIcon icon : this.icons) {
            icon.draw(mc, guiGraphics, context, x, y, width, height);
        }
    }

    public IconSerializer<CompoundIcon> getSerializer() {
        return (IconSerializer)IconSerializers.COMPOUND.get();
    }

    public static class Serializer
    extends IconSerializer<CompoundIcon> {
        @Override
        @NotNull
        public CompoundIcon fromJSON(JsonObject json) {
            JsonArray icons = GsonHelper.m_13933_((JsonObject)json, (String)"icons");
            CompoundIcon compoundIcon = new CompoundIcon();
            for (JsonElement jsonElement : icons) {
                IIcon icon = IconSerializer.parseJSON(jsonElement);
                compoundIcon.icons.add(icon);
            }
            return compoundIcon;
        }

        @Override
        public CompoundIcon fromNBT(CompoundTag nbt) {
            ListTag listTag = nbt.m_128437_("Icons", 10);
            CompoundIcon compoundIcon = new CompoundIcon();
            for (int i = 0; i < listTag.size(); ++i) {
                IIcon icon = IconSerializer.parseNBT(listTag.m_128728_(i));
                compoundIcon.icons.add(icon);
            }
            return compoundIcon;
        }

        @Override
        public JsonObject toJSON(CompoundIcon icon) {
            JsonObject jsonObject = new JsonObject();
            JsonArray jsonArray = new JsonArray();
            for (IIcon i : icon.icons) {
                jsonArray.add(IconSerializer.serializeJSON(i));
            }
            return jsonObject;
        }

        @Override
        public CompoundTag toNBT(CompoundIcon icon) {
            CompoundTag nbt = new CompoundTag();
            ListTag listTag = new ListTag();
            for (IIcon i : icon.icons) {
                listTag.add((Object)IconSerializer.serializeNBT(i));
            }
            nbt.m_128365_("Icons", (Tag)listTag);
            return nbt;
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Compound Icon");
            builder.setDescription("Let's you merge multiple icons into one.");
            JsonArray jsonArray = new JsonArray();
            jsonArray.add(IconSerializer.serializeJSON(new ItemIcon((ItemLike)Items.f_42410_)));
            jsonArray.add(IconSerializer.serializeJSON(new TexturedIcon(new ResourceLocation("example:textures/icons/my_icon.png"))));
            builder.addProperty("icons", IIcon[].class).description("Array of the icons you want to merge").required().exampleJson((JsonElement)jsonArray);
        }
    }
}

