/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.icon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.GsonHelper;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.IconSerializer;
import net.threetag.palladium.util.icon.IconSerializers;
import net.threetag.palladium.util.icon.TexturedIcon;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.NotNull;

public record ExperienceIcon(int amount, boolean level) implements IIcon
{
    private static final TexturedIcon BACKGROUND_ICON = new TexturedIcon(Palladium.id("textures/icon/experience.png"));

    @Override
    public void draw(Minecraft mc, GuiGraphics guiGraphics, DataContext context, int x, int y, int width, int height) {
        BACKGROUND_ICON.draw(mc, guiGraphics, context, x, y, width, height);
        PoseStack stack = guiGraphics.m_280168_();
        stack.m_85836_();
        stack.m_252880_((float)x, (float)y, 0.0f);
        if (width != 16 || height != 16) {
            stack.m_85841_((float)width / 16.0f, (float)height / 16.0f, 1.0f);
        }
        String text = this.amount + (this.level ? "L" : "");
        guiGraphics.m_280056_(mc.f_91062_, text, 9, 8, 0, false);
        guiGraphics.m_280056_(mc.f_91062_, text, 7, 8, 0, false);
        guiGraphics.m_280056_(mc.f_91062_, text, 8, 9, 0, false);
        guiGraphics.m_280056_(mc.f_91062_, text, 8, 7, 0, false);
        guiGraphics.m_280056_(mc.f_91062_, text, 8, 8, 8453920, false);
        stack.m_85849_();
    }

    public IconSerializer<ExperienceIcon> getSerializer() {
        return (IconSerializer)IconSerializers.EXPERIENCE.get();
    }

    @Override
    public String toString() {
        return "ExperienceIcon{amount=" + this.amount + ", level=" + this.level + "}";
    }

    public static class Serializer
    extends IconSerializer<ExperienceIcon> {
        @Override
        @NotNull
        public ExperienceIcon fromJSON(JsonObject json) {
            return new ExperienceIcon(GsonUtil.getAsIntMin(json, "amount", 0), GsonHelper.m_13855_((JsonObject)json, (String)"level", (boolean)true));
        }

        @Override
        public ExperienceIcon fromNBT(CompoundTag nbt) {
            return new ExperienceIcon(nbt.m_128451_("Amount"), nbt.m_128471_("Level"));
        }

        @Override
        public JsonObject toJSON(ExperienceIcon icon) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("amount", (Number)icon.amount);
            jsonObject.addProperty("level", Boolean.valueOf(icon.level));
            return jsonObject;
        }

        @Override
        public CompoundTag toNBT(ExperienceIcon icon) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("Amount", icon.amount);
            tag.m_128379_("Level", icon.level);
            return tag;
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Experience Icon");
            builder.setDescription("Displays an experience amount as an icon.");
            builder.addProperty("amount", Integer.class).description("Amount of experience points/level").required().exampleJson((JsonElement)new JsonPrimitive((Number)3));
            builder.addProperty("level", Boolean.class).description("Determines if icon should display level or not").fallback(true).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
    }
}

