/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.icon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.ItemLike;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.documentation.HTMLBuilder;
import net.threetag.palladium.documentation.IDocumentedConfigurable;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.icon.TexturedIcon;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladiumcore.registry.PalladiumRegistry;
import org.jetbrains.annotations.NotNull;

public abstract class IconSerializer<T extends IIcon>
implements IDocumentedConfigurable {
    public static final PalladiumRegistry<IconSerializer> REGISTRY = PalladiumRegistry.create(IconSerializer.class, (ResourceLocation)Palladium.id("icon_serializers"));

    public static IIcon parseJSON(JsonElement json) {
        if (json.isJsonPrimitive()) {
            String input = json.getAsString();
            if (input.endsWith(".png")) {
                return new TexturedIcon(new ResourceLocation(input));
            }
            if (input.startsWith("#")) {
                return new TexturedIcon(TextureReference.parse(input));
            }
            ResourceLocation id = new ResourceLocation(json.getAsString());
            if (!BuiltInRegistries.f_257033_.m_7804_(id)) {
                throw new JsonParseException("Unknown item '" + json.getAsString() + "'");
            }
            return new ItemIcon((ItemLike)BuiltInRegistries.f_257033_.m_7745_(id));
        }
        if (json.isJsonObject()) {
            ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json.getAsJsonObject(), (String)"type"));
            if (!REGISTRY.containsKey(id)) {
                throw new JsonParseException("Unknown icon type '" + String.valueOf(id) + "'");
            }
            IconSerializer serializer = (IconSerializer)REGISTRY.get(id);
            return Objects.requireNonNull(serializer).fromJSON(json.getAsJsonObject());
        }
        throw new JsonParseException("Icon must either be a string or an object");
    }

    public static JsonElement serializeJSON(IIcon icon) {
        if (icon instanceof ItemIcon) {
            ItemIcon itemIcon = (ItemIcon)icon;
            if (itemIcon.stack.m_41613_() == 1) {
                return new JsonPrimitive(BuiltInRegistries.f_257033_.m_7981_((Object)itemIcon.stack.m_41720_()).toString());
            }
        }
        if (icon instanceof TexturedIcon) {
            TexturedIcon texturedIcon = (TexturedIcon)icon;
            if (texturedIcon.tint == null) {
                return new JsonPrimitive(texturedIcon.texture.toString());
            }
        }
        IconSerializer<?> serializer = icon.getSerializer();
        JsonObject json = serializer.toJSON(icon);
        JsonObject json2 = new JsonObject();
        json2.addProperty("type", Objects.requireNonNull(REGISTRY.getKey(serializer)).toString());
        return GsonUtil.merge(json2, json);
    }

    public static IIcon parseNBT(CompoundTag tag) {
        ResourceLocation id = new ResourceLocation(tag.m_128461_("Type"));
        if (!REGISTRY.containsKey(id)) {
            return null;
        }
        IconSerializer serializer = (IconSerializer)REGISTRY.get(id);
        return Objects.requireNonNull(serializer).fromNBT(tag);
    }

    public static CompoundTag serializeNBT(IIcon icon) {
        IconSerializer<?> serializer = icon.getSerializer();
        CompoundTag nbt = serializer.toNBT(icon);
        nbt.m_128359_("Type", Objects.requireNonNull(REGISTRY.getKey(serializer)).toString());
        return nbt;
    }

    public static HTMLBuilder documentationBuilder() {
        return new HTMLBuilder(new ResourceLocation("palladium", "icons"), "Icons").add(HTMLBuilder.heading("Icons")).addDocumentationSettings(REGISTRY.getValues().stream().sorted(Comparator.comparing(o -> o.getId().toString())).collect(Collectors.toList()));
    }

    @NotNull
    public abstract T fromJSON(JsonObject var1);

    public abstract T fromNBT(CompoundTag var1);

    public abstract JsonObject toJSON(T var1);

    public abstract CompoundTag toNBT(T var1);

    @Override
    public ResourceLocation getId() {
        return REGISTRY.getKey((Object)this);
    }
}

