/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladium.util.property.PalladiumProperty;

public class AccessorySlotProperty
extends PalladiumProperty<AccessorySlot> {
    public AccessorySlotProperty(String key) {
        super(key);
    }

    @Override
    public AccessorySlot fromJSON(JsonElement jsonElement) {
        AccessorySlot slot = AccessorySlot.getSlotByName(GsonUtil.convertToResourceLocation(jsonElement, this.getKey()));
        if (slot == null) {
            throw new JsonParseException("Unknown accessory slot '" + jsonElement.getAsString() + "'");
        }
        return slot;
    }

    @Override
    public JsonElement toJSON(AccessorySlot value) {
        return new JsonPrimitive(value.getName().toString());
    }

    @Override
    public AccessorySlot fromNBT(Tag tag, AccessorySlot defaultValue) {
        if (tag instanceof StringTag) {
            StringTag stringTag = (StringTag)tag;
            return AccessorySlot.getSlotByName(new ResourceLocation(stringTag.m_7916_()));
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(AccessorySlot value) {
        return StringTag.m_129297_((String)value.getName().toString());
    }

    @Override
    public AccessorySlot fromBuffer(FriendlyByteBuf buf) {
        return AccessorySlot.getSlotByName(buf.m_130281_());
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        buf.m_130085_(((AccessorySlot)value).getName());
    }

    @Override
    public String getString(AccessorySlot value) {
        return value != null ? value.getName().toString() : null;
    }

    @Override
    public String getPropertyType() {
        return "accessory_slot";
    }
}

