/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import java.util.Locale;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.util.property.EnumPalladiumProperty;

public class ArmTypeProperty
extends EnumPalladiumProperty<ArmType> {
    public ArmTypeProperty(String key) {
        super(key);
    }

    public ArmType[] getValues() {
        return ArmType.values();
    }

    @Override
    public String getNameFromEnum(ArmType value) {
        return value.name().toLowerCase(Locale.ROOT);
    }

    public static enum ArmType {
        NONE,
        MAIN_ARM,
        OFF_ARM,
        RIGHT_ARM,
        LEFT_ARM,
        BOTH;


        @OnlyIn(value=Dist.CLIENT)
        public ModelPart[] getModelPart(LivingEntity entity, HumanoidModel<?> model) {
            if (this == NONE) {
                return new ModelPart[0];
            }
            if (this == MAIN_ARM) {
                if (entity.m_5737_() == HumanoidArm.RIGHT) {
                    return new ModelPart[]{model.f_102811_};
                }
                return new ModelPart[]{model.f_102812_};
            }
            if (this == OFF_ARM) {
                if (entity.m_5737_() == HumanoidArm.RIGHT) {
                    return new ModelPart[]{model.f_102812_};
                }
                return new ModelPart[]{model.f_102811_};
            }
            if (this == RIGHT_ARM) {
                return new ModelPart[]{model.f_102811_};
            }
            if (this == LEFT_ARM) {
                return new ModelPart[]{model.f_102812_};
            }
            return new ModelPart[]{model.f_102811_, model.f_102812_};
        }

        public InteractionHand[] getHand(LivingEntity entity) {
            if (this.isNone()) {
                return new InteractionHand[0];
            }
            if (this.isBoth()) {
                return InteractionHand.values();
            }
            if (this == MAIN_ARM) {
                return new InteractionHand[]{InteractionHand.MAIN_HAND};
            }
            if (this == OFF_ARM) {
                return new InteractionHand[]{InteractionHand.OFF_HAND};
            }
            if (this == RIGHT_ARM) {
                return new InteractionHand[]{entity.m_5737_() == HumanoidArm.RIGHT ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND};
            }
            return new InteractionHand[]{entity.m_5737_() == HumanoidArm.RIGHT ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND};
        }

        public boolean isNone() {
            return this == NONE;
        }

        public boolean isBoth() {
            return this == BOTH;
        }

        public boolean isRight(LivingEntity entity) {
            if (this == RIGHT_ARM || this == BOTH) {
                return true;
            }
            if (this == MAIN_ARM) {
                return entity.m_5737_() == HumanoidArm.RIGHT;
            }
            if (this == OFF_ARM) {
                return entity.m_5737_() != HumanoidArm.RIGHT;
            }
            return false;
        }

        public boolean isLeft(LivingEntity entity) {
            if (this == LEFT_ARM || this == BOTH) {
                return true;
            }
            if (this == MAIN_ARM) {
                return entity.m_5737_() == HumanoidArm.LEFT;
            }
            if (this == OFF_ARM) {
                return entity.m_5737_() != HumanoidArm.LEFT;
            }
            return false;
        }
    }
}

