/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec2;
import net.threetag.palladium.util.property.PalladiumProperty;

public class Vec2Property
extends PalladiumProperty<Vec2> {
    public Vec2Property(String key) {
        super(key);
    }

    @Override
    public Vec2 fromJSON(JsonElement jsonElement) {
        JsonArray array = jsonElement.getAsJsonArray();
        if (array.size() != 2) {
            throw new JsonParseException(this.getKey() + " must be an array with two float");
        }
        return new Vec2(array.get(0).getAsFloat(), array.get(1).getAsFloat());
    }

    @Override
    public JsonElement toJSON(Vec2 value) {
        JsonArray array = new JsonArray();
        array.add((Number)Float.valueOf(value.f_82470_));
        array.add((Number)Float.valueOf(value.f_82471_));
        return array;
    }

    @Override
    public Vec2 fromNBT(Tag tag, Vec2 defaultValue) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            return new Vec2(compoundTag.m_128457_("X"), compoundTag.m_128457_("Y"));
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(Vec2 value) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128350_("X", value.f_82470_);
        compoundTag.m_128350_("Y", value.f_82471_);
        return compoundTag;
    }

    @Override
    public Vec2 fromBuffer(FriendlyByteBuf buf) {
        return new Vec2(buf.readFloat(), buf.readFloat());
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        Vec2 vec = (Vec2)value;
        buf.writeFloat(vec.f_82470_);
        buf.writeFloat(vec.f_82471_);
    }

    @Override
    public String getString(Vec2 value) {
        return value != null ? "[" + value.f_82470_ + " / " + value.f_82471_ + "]" : null;
    }
}

