/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1764;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_364;
import net.minecraft.class_3883;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5601;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.PalladiumConfig;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.block.IAddonBlock;
import net.threetag.palladium.block.PalladiumBlocks;
import net.threetag.palladium.client.PalladiumKeyMappings;
import net.threetag.palladium.client.dynamictexture.DynamicTextureManager;
import net.threetag.palladium.client.energybeam.EnergyBeamManager;
import net.threetag.palladium.client.model.SuitStandBasePlateModel;
import net.threetag.palladium.client.model.SuitStandModel;
import net.threetag.palladium.client.model.animation.AimAnimation;
import net.threetag.palladium.client.model.animation.FlightAnimation;
import net.threetag.palladium.client.model.animation.HoveringAnimation;
import net.threetag.palladium.client.model.animation.LevitationAnimation;
import net.threetag.palladium.client.model.animation.PalladiumAnimationRegistry;
import net.threetag.palladium.client.particleemitter.ParticleEmitterManager;
import net.threetag.palladium.client.renderer.WatcherRenderer;
import net.threetag.palladium.client.renderer.entity.CustomProjectileRenderer;
import net.threetag.palladium.client.renderer.entity.EffectEntityRenderer;
import net.threetag.palladium.client.renderer.entity.SuitStandRenderer;
import net.threetag.palladium.client.renderer.entity.TrailSegmentEntityRenderer;
import net.threetag.palladium.client.renderer.item.armor.ArmorRendererManager;
import net.threetag.palladium.client.renderer.renderlayer.AccessoryRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerManager;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerRenderer;
import net.threetag.palladium.client.renderer.trail.TrailRendererManager;
import net.threetag.palladium.client.screen.AbilityBarRenderer;
import net.threetag.palladium.client.screen.AbilityWheelRenderer;
import net.threetag.palladium.client.screen.AccessoryScreen;
import net.threetag.palladium.client.screen.AddonPackLogScreen;
import net.threetag.palladium.client.screen.components.IconButton;
import net.threetag.palladium.client.screen.power.PowersScreen;
import net.threetag.palladium.compat.geckolib.GeckoLibCompat;
import net.threetag.palladium.compat.mermod.MermodClientCompatImpl;
import net.threetag.palladium.energy.EnergyHelper;
import net.threetag.palladium.energy.IEnergyStorage;
import net.threetag.palladium.entity.PalladiumEntityTypes;
import net.threetag.palladium.event.PalladiumClientEvents;
import net.threetag.palladium.item.AddonBowItem;
import net.threetag.palladium.item.AddonCrossbowItem;
import net.threetag.palladium.item.AddonShieldItem;
import net.threetag.palladium.item.EnergyItem;
import net.threetag.palladium.item.Openable;
import net.threetag.palladium.item.PalladiumItems;
import net.threetag.palladium.power.ability.AbilityClientEventHandler;
import net.threetag.palladium.power.ability.GuiOverlayAbility;
import net.threetag.palladium.util.SupporterHandler;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.TexturedIcon;
import net.threetag.palladiumcore.event.LifecycleEvents;
import net.threetag.palladiumcore.event.ScreenEvents;
import net.threetag.palladiumcore.registry.ReloadListenerRegistry;
import net.threetag.palladiumcore.registry.client.ColorHandlerRegistry;
import net.threetag.palladiumcore.registry.client.EntityRendererRegistry;
import net.threetag.palladiumcore.registry.client.ItemPropertyRegistry;
import net.threetag.palladiumcore.registry.client.OverlayRegistry;
import net.threetag.palladiumcore.registry.client.RenderTypeRegistry;
import net.threetag.palladiumcore.util.Platform;

public class PalladiumClient {
    public static final IIcon ICON = new TexturedIcon(Palladium.id("textures/icon/palladium.png"));

    public static void init() {
        PalladiumClient.colorHandlers();
        PalladiumKeyMappings.init();
        PowersScreen.register();
        AccessoryScreen.addButton();
        SupporterHandler.clientInit();
        PalladiumClient.setupDevLogButton();
        AbilityClientEventHandler.init();
        WatcherRenderer.init();
        LifecycleEvents.SETUP.register(() -> {
            PalladiumClient.blockRenderTypes();
            PalladiumClient.itemModelPredicates();
        });
        EntityRendererRegistry.register(PalladiumEntityTypes.EFFECT, EffectEntityRenderer::new);
        EntityRendererRegistry.register(PalladiumEntityTypes.TRAIL_SEGMENT, TrailSegmentEntityRenderer::new);
        EntityRendererRegistry.register(PalladiumEntityTypes.CUSTOM_PROJECTILE, CustomProjectileRenderer::new);
        EntityRendererRegistry.register(PalladiumEntityTypes.SUIT_STAND, SuitStandRenderer::new);
        EntityRendererRegistry.registerModelLayer((class_5601)SuitStandModel.MODEL_LAYER_LOCATION, SuitStandModel::createBodyLayer);
        EntityRendererRegistry.registerModelLayer((class_5601)SuitStandBasePlateModel.MODEL_LAYER_LOCATION, SuitStandBasePlateModel::createLayer);
        EntityRendererRegistry.addRenderLayer(e -> true, renderLayerParent -> new PackRenderLayerRenderer((class_3883<class_1297, class_583<class_1297>>)renderLayerParent));
        EntityRendererRegistry.addRenderLayerToPlayer(renderLayerParent -> new AccessoryRenderLayer((class_3883<class_742, class_591<class_742>>)renderLayerParent));
        PalladiumClientEvents.REGISTER_ANIMATIONS.register(registry -> {
            registry.accept(Palladium.id("hovering"), new HoveringAnimation(-30));
            registry.accept(Palladium.id("levitation"), new LevitationAnimation(-20));
            registry.accept(Palladium.id("flight"), new FlightAnimation(-10));
            registry.accept(Palladium.id("aim"), new AimAnimation(100));
        });
        OverlayRegistry.registerOverlay((String)"palladium/ability_bar", (OverlayRegistry.IngameOverlay)new AbilityBarRenderer());
        OverlayRegistry.registerOverlay((String)"palladium/gui_overlay_abilities", (OverlayRegistry.IngameOverlay)new GuiOverlayAbility.Renderer());
        OverlayRegistry.registerOverlay((String)"palladium/ability_wheel", (OverlayRegistry.IngameOverlay)new AbilityWheelRenderer());
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_2960)Palladium.id("dynamic_textures"), (class_3302)new DynamicTextureManager());
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_2960)Palladium.id("pack_render_layers"), (class_3302)new PackRenderLayerManager());
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_2960)Palladium.id("armor_renderers"), (class_3302)new ArmorRendererManager());
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_2960)Palladium.id("accessory_renderers"), (class_3302)new Accessory.ReloadManager());
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_2960)Palladium.id("humanoid_animations"), (class_3302)PalladiumAnimationRegistry.INSTANCE);
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_2960)Palladium.id("trail_renderers"), (class_3302)TrailRendererManager.INSTANCE);
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_2960)Palladium.id("particle_emitters"), (class_3302)ParticleEmitterManager.INSTANCE);
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_2960)Palladium.id("energy_beams"), (class_3302)EnergyBeamManager.INSTANCE);
        if (Platform.isModLoaded((String)"geckolib")) {
            GeckoLibCompat.initClient();
        }
        if (Platform.isModLoaded((String)"mermod")) {
            MermodClientCompatImpl.init();
        }
    }

    public static void blockRenderTypes() {
        RenderTypeRegistry.registerBlock((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)PalladiumBlocks.HEART_SHAPED_HERB.get(), (class_2248)PalladiumBlocks.POTTED_HEART_SHAPED_HERB.get(), (class_2248)PalladiumBlocks.SMALL_REDSTONE_FLUX_CRYSTAL_BUD.get(), (class_2248)PalladiumBlocks.MEDIUM_REDSTONE_FLUX_CRYSTAL_BUD.get(), (class_2248)PalladiumBlocks.LARGE_REDSTONE_FLUX_CRYSTAL_BUD.get(), (class_2248)PalladiumBlocks.REDSTONE_FLUX_CRYSTAL_CLUSTER.get()});
        for (class_2248 block : class_7923.field_41175) {
            IAddonBlock addonBlock;
            String type;
            if (!(block instanceof IAddonBlock) || (type = (addonBlock = (IAddonBlock)block).getRenderType()) == null) continue;
            if (type.equalsIgnoreCase("solid")) {
                RenderTypeRegistry.registerBlock((class_1921)class_1921.method_23577(), (class_2248[])new class_2248[]{block});
                continue;
            }
            if (type.equalsIgnoreCase("cutout_mipped")) {
                RenderTypeRegistry.registerBlock((class_1921)class_1921.method_23579(), (class_2248[])new class_2248[]{block});
                continue;
            }
            if (type.equalsIgnoreCase("cutout")) {
                RenderTypeRegistry.registerBlock((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{block});
                continue;
            }
            if (!type.equalsIgnoreCase("translucent")) continue;
            RenderTypeRegistry.registerBlock((class_1921)class_1921.method_23583(), (class_2248[])new class_2248[]{block});
        }
    }

    public static void itemModelPredicates() {
        for (class_1792 item : class_7923.field_41178) {
            if (item instanceof EnergyItem) {
                ItemPropertyRegistry.register((class_1792)item, (class_2960)Palladium.id("energy"), (itemStack, clientLevel, livingEntity, i) -> {
                    Optional<IEnergyStorage> storage = EnergyHelper.getFromItemStack(itemStack);
                    return storage.map(energyStorage -> Math.round(13.0f * (float)energyStorage.getEnergyAmount() / (float)energyStorage.getEnergyCapacity())).orElse(0).intValue();
                });
                ItemPropertyRegistry.register((class_1792)item, (class_2960)Palladium.id("charged"), (itemStack, clientLevel, livingEntity, i) -> itemStack.method_7948().method_10550("energy") > 0 ? 1.0f : 0.0f);
            }
            if (item instanceof Openable) {
                Openable openable = (Openable)item;
                ItemPropertyRegistry.register((class_1792)item, (class_2960)Palladium.id("opened"), (itemStack, clientLevel, livingEntity, i) -> {
                    int max = openable.getOpeningTime(itemStack);
                    if (max > 0) {
                        return (float)openable.getOpeningProgress(itemStack) / (float)max;
                    }
                    return openable.isOpen(itemStack) ? 1.0f : 0.0f;
                });
            }
            if (item instanceof AddonShieldItem) {
                ItemPropertyRegistry.register((class_1792)item, (class_2960)new class_2960("blocking"), (itemStack, clientLevel, livingEntity, i) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
            }
            if (item instanceof AddonBowItem) {
                ItemPropertyRegistry.register((class_1792)item, (class_2960)new class_2960("pull"), (itemStack, clientLevel, livingEntity, i) -> {
                    if (livingEntity == null) {
                        return 0.0f;
                    }
                    return livingEntity.method_6030() != itemStack ? 0.0f : (float)(itemStack.method_7935() - livingEntity.method_6014()) / 20.0f;
                });
                ItemPropertyRegistry.register((class_1792)item, (class_2960)new class_2960("pulling"), (itemStack, clientLevel, livingEntity, i) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
            }
            if (!(item instanceof AddonCrossbowItem)) continue;
            ItemPropertyRegistry.register((class_1792)item, (class_2960)new class_2960("pull"), (itemStack, clientLevel, livingEntity, i) -> {
                if (livingEntity == null) {
                    return 0.0f;
                }
                return class_1764.method_7781((class_1799)itemStack) ? 0.0f : (float)(itemStack.method_7935() - livingEntity.method_6014()) / (float)class_1764.method_7775((class_1799)itemStack);
            });
            ItemPropertyRegistry.register((class_1792)item, (class_2960)new class_2960("pulling"), (itemStack, clientLevel, livingEntity, i) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack && !class_1764.method_7781((class_1799)itemStack) ? 1.0f : 0.0f);
            ItemPropertyRegistry.register((class_1792)item, (class_2960)new class_2960("charged"), (itemStack, clientLevel, livingEntity, i) -> livingEntity != null && class_1764.method_7781((class_1799)itemStack) ? 1.0f : 0.0f);
            ItemPropertyRegistry.register((class_1792)item, (class_2960)new class_2960("firework"), (itemStack, clientLevel, livingEntity, i) -> livingEntity != null && class_1764.method_7781((class_1799)itemStack) && class_1764.method_7772((class_1799)itemStack, (class_1792)class_1802.field_8639) ? 1.0f : 0.0f);
        }
    }

    public static void colorHandlers() {
        ColorHandlerRegistry.registerItemColors((itemStack, i) -> i > 0 ? -1 : ((class_1768)itemStack.method_7909()).method_7800(itemStack), (Supplier[])new Supplier[]{PalladiumItems.VIBRANIUM_WEAVE_BOOTS});
    }

    public static void setupDevLogButton() {
        ScreenEvents.INIT_POST.register(screen -> {
            if (((Boolean)PalladiumConfig.Client.ADDON_PACK_DEV_MODE.get()).booleanValue() && (screen instanceof class_442 || screen instanceof class_433)) {
                screen.method_37063((class_364)IconButton.builder(ICON, button -> class_310.method_1551().method_1507((class_437)new AddonPackLogScreen(AddonPackLog.getEntries(), screen))).pos(screen.field_22789 - 30, 10).tooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.palladium.addon_pack_log"))).build());
            }
        });
    }
}

