/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.accessory;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.network.SyncAccessoriesMessage;
import net.threetag.palladiumcore.util.Platform;
import org.jetbrains.annotations.Nullable;

public class AccessoryPlayerData {
    public Map<AccessorySlot, Collection<Accessory>> accessories = new HashMap<AccessorySlot, Collection<Accessory>>();

    public void enable(AccessorySlot slot, Accessory accessory, class_1657 player) {
        if (slot != null && accessory != null && accessory.getPossibleSlots().contains(slot) && this.canEnable(accessory, player)) {
            if (slot.allowsMultiple()) {
                Collection accessories = this.accessories.computeIfAbsent(slot, accessorySlot -> new ArrayList());
                if (!accessories.contains(accessory)) {
                    accessories.add(accessory);
                }
            } else {
                this.accessories.put(slot, Collections.singletonList(accessory));
            }
            if (!player.method_37908().field_9236) {
                new SyncAccessoriesMessage(player.method_5628(), this.accessories).sendToDimension(player.method_37908());
            }
        }
    }

    public boolean canEnable(Accessory accessory, class_1657 player) {
        return Platform.isClient() || accessory.isAvailable(player);
    }

    public void disable(AccessorySlot slot, @Nullable Accessory accessory, class_1657 player) {
        if (slot != null && accessory != null) {
            if (slot.allowsMultiple()) {
                Collection accessories = this.accessories.computeIfAbsent(slot, accessorySlot -> new ArrayList());
                accessories.remove(accessory);
            } else {
                this.accessories.put(slot, new ArrayList());
            }
            if (!player.method_37908().field_9236) {
                new SyncAccessoriesMessage(player.method_5628(), this.accessories).sendToDimension(player.method_37908());
            }
        }
    }

    public void validate(class_1657 player) {
        ArrayList disable = new ArrayList();
        this.accessories.forEach((slot, accessories) -> {
            for (Accessory accessory : accessories) {
                if (this.canEnable(accessory, player)) continue;
                disable.add(Pair.of((Object)slot, (Object)accessory));
            }
        });
        for (Pair pair : disable) {
            this.disable((AccessorySlot)pair.getFirst(), (Accessory)pair.getSecond(), player);
        }
    }

    public void clear(class_1657 player) {
        this.accessories.clear();
        for (AccessorySlot slot : AccessorySlot.getSlots()) {
            this.accessories.put(slot, new ArrayList());
        }
        if (!player.method_37908().field_9236) {
            new SyncAccessoriesMessage(player.method_5628(), this.accessories).sendToDimension(player.method_37908());
        }
    }

    public Map<AccessorySlot, Collection<Accessory>> getSlots() {
        return this.accessories;
    }

    public class_2487 toNBT() {
        class_2487 nbt = new class_2487();
        this.accessories.forEach((slot, list) -> {
            class_2499 listNBT = new class_2499();
            for (Accessory accessory : list) {
                listNBT.add((Object)class_2519.method_23256((String)Objects.requireNonNull(Accessory.REGISTRY.getKey((Object)accessory)).toString()));
            }
            nbt.method_10566(slot.getName().toString(), (class_2520)listNBT);
        });
        return nbt;
    }

    public void fromNBT(class_2487 nbt) {
        this.accessories = new HashMap<AccessorySlot, Collection<Accessory>>();
        for (AccessorySlot slot : AccessorySlot.getSlots()) {
            class_2499 listNBT = nbt.method_10554(slot.getName().toString(), 8);
            ArrayList<Accessory> accessories = new ArrayList<Accessory>();
            for (int i = 0; i < listNBT.size(); ++i) {
                Accessory accessory = (Accessory)Accessory.REGISTRY.get(new class_2960(listNBT.method_10608(i)));
                if (accessory == null) continue;
                accessories.add(accessory);
            }
            this.accessories.put(slot, accessories);
        }
    }
}

