/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.threetag.palladium.client.screen.AbilityBarRenderer;
import net.threetag.palladium.client.screen.AbilityWheelRenderer;
import net.threetag.palladium.network.AbilityKeyPressedMessage;
import net.threetag.palladium.network.NotifyMovementKeyListenerMessage;
import net.threetag.palladium.network.ToggleOpenableEquipmentMessage;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityConfiguration;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.util.property.PalladiumProperties;
import net.threetag.palladiumcore.event.ClientTickEvents;
import net.threetag.palladiumcore.event.EventResult;
import net.threetag.palladiumcore.event.InputEvents;
import net.threetag.palladiumcore.registry.client.KeyMappingRegistry;

@Environment(value=EnvType.CLIENT)
public class PalladiumKeyMappings
implements InputEvents.KeyPressed,
ClientTickEvents.ClientTick,
InputEvents.MouseScrolling {
    public static final String CATEGORY = "key.palladium.categories.abilities";
    public static final class_304 OPEN_EQUIPMENT = new class_304("key.palladium.open_equipment", 47, "key.categories.gameplay");
    public static final class_304 SWITCH_ABILITY_LIST = new class_304("key.palladium.switch_ability_list", 88, "key.palladium.categories.abilities");
    public static AbilityKeyMapping[] ABILITY_KEYS = new AbilityKeyMapping[5];
    public static AbilityInstance LEFT_CLICKED_ABILITY = null;
    public static AbilityInstance RIGHT_CLICKED_ABILITY = null;
    public static AbilityInstance SPACE_BAR_ABILITY = null;

    public static void init() {
        KeyMappingRegistry.register((class_304)OPEN_EQUIPMENT);
        KeyMappingRegistry.register((class_304)SWITCH_ABILITY_LIST);
        for (int i = 1; i <= ABILITY_KEYS.length; ++i) {
            AbilityKeyMapping abilityKeyMapping = new AbilityKeyMapping("key.palladium.ability_" + i, i == 1 ? 86 : (i == 2 ? 66 : (i == 3 ? 78 : (i == 4 ? 77 : (i == 5 ? 44 : -1)))), CATEGORY, i);
            PalladiumKeyMappings.ABILITY_KEYS[i - 1] = abilityKeyMapping;
            KeyMappingRegistry.register((class_304)abilityKeyMapping);
        }
        PalladiumKeyMappings instance = new PalladiumKeyMappings();
        InputEvents.KEY_PRESSED.register((Object)instance);
        InputEvents.MOUSE_SCROLLING.register((Object)instance);
        ClientTickEvents.CLIENT_POST.register((Object)instance);
    }

    public void keyPressed(class_310 client, int keyCode, int scanCode, int action, int modifiers) {
        if (client.field_1724 != null && client.field_1755 == null && !client.field_1724.method_7325()) {
            AbilityInstance entry;
            if (OPEN_EQUIPMENT.method_1434()) {
                new ToggleOpenableEquipmentMessage().send();
                return;
            }
            if (SWITCH_ABILITY_LIST.method_1434()) {
                AbilityBarRenderer.scroll(!client.field_1724.method_18276());
                return;
            }
            AbilityBarRenderer.AbilityList list = AbilityBarRenderer.getSelectedList();
            if (list != null && action != 2) {
                for (AbilityKeyMapping key : ABILITY_KEYS) {
                    AbilityInstance entry2 = list.getDisplayedAbilities()[key.index - 1];
                    if (entry2 == null || action == 1 && entry2.getConfiguration().needsEmptyHand() && !client.field_1724.method_6047().method_7960()) continue;
                    if (key.method_1417(keyCode, scanCode) && entry2.getConfiguration().getKeyType() == AbilityConfiguration.KeyType.KEY_BIND) {
                        new AbilityKeyPressedMessage(entry2.getReference(), action == 1).send();
                        continue;
                    }
                    if (entry2.getConfiguration().getKeyType() != AbilityConfiguration.KeyType.SPACE_BAR || !client.field_1690.field_1903.method_1417(keyCode, scanCode)) continue;
                    new AbilityKeyPressedMessage(entry2.getReference(), action == 1).send();
                    return;
                }
            }
            if (SPACE_BAR_ABILITY == null && client.field_1690.field_1903.method_1434() && (entry = PalladiumKeyMappings.getPrioritisedKeyedAbility(AbilityConfiguration.KeyType.SPACE_BAR)) != null && entry.isUnlocked() && (!entry.getConfiguration().needsEmptyHand() || client.field_1724.method_6047().method_7960())) {
                AbilityConfiguration.KeyPressType pressType = entry.getConfiguration().getKeyPressType();
                if (pressType == AbilityConfiguration.KeyPressType.ACTION) {
                    if (!entry.isOnCooldown()) {
                        new AbilityKeyPressedMessage(entry.getReference(), true).send();
                        SPACE_BAR_ABILITY = entry;
                    }
                } else if (pressType == AbilityConfiguration.KeyPressType.ACTIVATION) {
                    if (!entry.isOnCooldown() && !entry.isEnabled()) {
                        new AbilityKeyPressedMessage(entry.getReference(), true).send();
                        SPACE_BAR_ABILITY = entry;
                    }
                } else {
                    new AbilityKeyPressedMessage(entry.getReference(), true).send();
                    SPACE_BAR_ABILITY = entry;
                }
            }
            if (PalladiumProperties.JUMP_KEY_DOWN.isRegistered((class_1297)client.field_1724) && client.field_1690.field_1903.method_1434() != PalladiumProperties.JUMP_KEY_DOWN.get((class_1297)client.field_1724).booleanValue()) {
                new NotifyMovementKeyListenerMessage(0, client.field_1690.field_1903.method_1434()).send();
            }
            if (PalladiumProperties.LEFT_KEY_DOWN.isRegistered((class_1297)client.field_1724) && client.field_1690.field_1913.method_1434() != PalladiumProperties.LEFT_KEY_DOWN.get((class_1297)client.field_1724).booleanValue()) {
                new NotifyMovementKeyListenerMessage(1, client.field_1690.field_1913.method_1434()).send();
            }
            if (PalladiumProperties.RIGHT_KEY_DOWN.isRegistered((class_1297)client.field_1724) && client.field_1690.field_1849.method_1434() != PalladiumProperties.RIGHT_KEY_DOWN.get((class_1297)client.field_1724).booleanValue()) {
                new NotifyMovementKeyListenerMessage(2, client.field_1690.field_1849.method_1434()).send();
            }
            if (PalladiumProperties.FORWARD_KEY_DOWN.isRegistered((class_1297)client.field_1724) && client.field_1690.field_1894.method_1434() != PalladiumProperties.FORWARD_KEY_DOWN.get((class_1297)client.field_1724).booleanValue()) {
                new NotifyMovementKeyListenerMessage(3, client.field_1690.field_1894.method_1434()).send();
            }
            if (PalladiumProperties.BACKWARDS_KEY_DOWN.isRegistered((class_1297)client.field_1724) && client.field_1690.field_1881.method_1434() != PalladiumProperties.BACKWARDS_KEY_DOWN.get((class_1297)client.field_1724).booleanValue()) {
                new NotifyMovementKeyListenerMessage(4, client.field_1690.field_1881.method_1434()).send();
            }
        }
    }

    public EventResult mouseScrolling(class_310 client, double scrollDelta, boolean leftDown, boolean middleDown, boolean rightDown, double mouseX, double mouseY) {
        class_746 player = Objects.requireNonNull(client.field_1724);
        if (AbilityUtil.isTypeEnabled((class_1309)player, (Ability)Abilities.DISABLE_HOTBAR_SCROLL.get())) {
            return EventResult.cancel();
        }
        List<AbilityInstance> activeToggles = AbilityUtil.getInstances((class_1309)player).stream().filter(e -> e.getConfiguration().getKeyPressType() == AbilityConfiguration.KeyPressType.TOGGLE && e.getConfiguration().getKeyType().toString().toLowerCase(Locale.ROOT).startsWith("scroll") && e.isEnabled()).toList();
        for (AbilityInstance active : activeToggles) {
            if (!(active.getConfiguration().getKeyType() == AbilityConfiguration.KeyType.SCROLL_UP && scrollDelta < 0.0 || active.getConfiguration().getKeyType() == AbilityConfiguration.KeyType.SCROLL_DOWN && scrollDelta > 0.0) && (active.getConfiguration().getKeyType() != AbilityConfiguration.KeyType.SCROLL_EITHER || scrollDelta == 0.0)) continue;
            new AbilityKeyPressedMessage(active.getReference(), true).send();
            return EventResult.cancel();
        }
        if (AbilityWheelRenderer.CURRENT_WHEEL != null && !AbilityWheelRenderer.CURRENT_WHEEL.disablesMouseScrolling()) {
            AbilityWheelRenderer.CURRENT_WHEEL.scroll(scrollDelta < 0.0);
            return EventResult.cancel();
        }
        AbilityInstance entry = null;
        if (scrollDelta > 0.0) {
            entry = PalladiumKeyMappings.getPrioritisedKeyedAbility(AbilityConfiguration.KeyType.SCROLL_UP);
        } else if (scrollDelta < 0.0) {
            entry = PalladiumKeyMappings.getPrioritisedKeyedAbility(AbilityConfiguration.KeyType.SCROLL_DOWN);
        }
        if (entry == null) {
            entry = PalladiumKeyMappings.getPrioritisedKeyedAbility(AbilityConfiguration.KeyType.SCROLL_EITHER);
        }
        if (entry != null && entry.isUnlocked() && (!entry.getConfiguration().needsEmptyHand() || player.method_6047().method_7960())) {
            AbilityConfiguration.KeyPressType pressType = entry.getConfiguration().getKeyPressType();
            if (pressType == AbilityConfiguration.KeyPressType.ACTION) {
                if (!entry.isOnCooldown()) {
                    new AbilityKeyPressedMessage(entry.getReference(), true).send();
                    return EventResult.cancel();
                }
            } else if (pressType == AbilityConfiguration.KeyPressType.ACTIVATION) {
                if (!entry.isOnCooldown() && !entry.isEnabled()) {
                    new AbilityKeyPressedMessage(entry.getReference(), true).send();
                    return EventResult.cancel();
                }
            } else if (pressType == AbilityConfiguration.KeyPressType.TOGGLE) {
                new AbilityKeyPressedMessage(entry.getReference(), true).send();
                return EventResult.cancel();
            }
        }
        return EventResult.pass();
    }

    public void clientTick(class_310 minecraft) {
        if (minecraft.field_1724 != null && minecraft.field_1755 == null && !minecraft.field_1724.method_7325()) {
            if (LEFT_CLICKED_ABILITY != null && !minecraft.field_1690.field_1886.method_1434()) {
                new AbilityKeyPressedMessage(LEFT_CLICKED_ABILITY.getReference(), false).send();
                LEFT_CLICKED_ABILITY = null;
            }
            if (RIGHT_CLICKED_ABILITY != null && !minecraft.field_1690.field_1904.method_1434()) {
                new AbilityKeyPressedMessage(RIGHT_CLICKED_ABILITY.getReference(), false).send();
                RIGHT_CLICKED_ABILITY = null;
            }
            if (SPACE_BAR_ABILITY != null && !minecraft.field_1690.field_1903.method_1434()) {
                new AbilityKeyPressedMessage(SPACE_BAR_ABILITY.getReference(), false).send();
                SPACE_BAR_ABILITY = null;
            }
        }
    }

    public static AbilityInstance getPrioritisedKeyedAbility(AbilityConfiguration.KeyType keyType) {
        AbilityBarRenderer.AbilityList list = AbilityBarRenderer.getSelectedList();
        if (list != null) {
            for (AbilityInstance ability : list.getDisplayedAbilities()) {
                if (ability == null || !ability.isUnlocked() || ability.getConfiguration().getKeyType() != keyType || ability.getConfiguration().getKeyType().toString().toLowerCase(Locale.ROOT).startsWith("scroll") && ability.getConfiguration().allowScrollWhenCrouching() && Objects.requireNonNull(class_310.method_1551().field_1724).method_18276()) continue;
                return ability;
            }
        }
        for (AbilityInstance entry : AbilityUtil.getInstances((class_1309)class_310.method_1551().field_1724)) {
            if (entry == null || !entry.isUnlocked() || entry.getConfiguration().getKeyType() != keyType || entry.getConfiguration().getKeyType().toString().toLowerCase(Locale.ROOT).startsWith("scroll") && entry.getConfiguration().allowScrollWhenCrouching() && Objects.requireNonNull(class_310.method_1551().field_1724).method_18276()) continue;
            return entry;
        }
        return null;
    }

    public static class AbilityKeyMapping
    extends class_304 {
        public final int index;

        public AbilityKeyMapping(String description, int keyCode, String category, int index) {
            super(description, keyCode, category);
            this.index = index;
        }
    }
}

