/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.variable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.class_3518;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.context.DataContext;

public abstract class AbstractBooleanTextureVariable
implements ITextureVariable {
    public final String trueValue;
    public final String falseValue;

    public AbstractBooleanTextureVariable(String trueValue, String falseValue) {
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }

    public abstract boolean getBoolean(DataContext var1);

    @Override
    public Object get(DataContext context) {
        return this.getBoolean(context) ? this.trueValue : this.falseValue;
    }

    public static String parseTrueValue(JsonObject json) {
        return class_3518.method_15253((JsonObject)json, (String)"true_value", (String)"true");
    }

    public static String parseFalseValue(JsonObject json) {
        return class_3518.method_15253((JsonObject)json, (String)"false_value", (String)"false");
    }

    public static void addDocumentationFields(JsonDocumentationBuilder builder) {
        builder.addProperty("true_value", Boolean.class).description("If the variable turns out to be true, this value will be inserted into the texture path").fallback(true, "true").exampleJson((JsonElement)new JsonPrimitive("true"));
        builder.addProperty("false_value", Boolean.class).description("If the variable turns out to be false, this value will be inserted into the texture path").fallback(false, "false").exampleJson((JsonElement)new JsonPrimitive("false"));
    }
}

