/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.variable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.dynamictexture.variable.AbstractIntegerTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariableSerializer;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.property.EntityPropertyHandler;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;

public class IntegerPropertyVariable
extends AbstractIntegerTextureVariable {
    private final String propertyKey;
    private final int fallbackValue;

    public IntegerPropertyVariable(String propertyKey, int fallbackValue, List<Pair<AbstractIntegerTextureVariable.Operation, Integer>> operations) {
        super(operations);
        this.propertyKey = propertyKey;
        this.fallbackValue = fallbackValue;
    }

    @Override
    public int getNumber(DataContext context) {
        AtomicInteger result = new AtomicInteger(this.fallbackValue);
        EntityPropertyHandler.getHandler(context.getEntity()).ifPresent(handler -> {
            PalladiumProperty<?> property = handler.getPropertyByName(this.propertyKey);
            if (property instanceof IntegerProperty) {
                IntegerProperty integerProperty = (IntegerProperty)property;
                result.set(handler.get(integerProperty));
            }
        });
        return result.get();
    }

    public static class Serializer
    implements ITextureVariableSerializer {
        @Override
        public ITextureVariable parse(JsonObject json) {
            return new IntegerPropertyVariable(class_3518.method_15265((JsonObject)json, (String)"property"), class_3518.method_15282((JsonObject)json, (String)"fallback", (int)0), AbstractIntegerTextureVariable.parseOperations(json));
        }

        @Override
        public String getDocumentationDescription() {
            return "Returns the value of an integer property within the player. The math operations can be arranged in any order and are fully optional!";
        }

        @Override
        public void addDocumentationFields(JsonDocumentationBuilder builder) {
            builder.setTitle("Integer Property");
            builder.addProperty("property", String.class).description("Name of the property you want the value from.").required().exampleJson((JsonElement)new JsonPrimitive("example_property"));
            builder.addProperty("fallback", Integer.class).description("If the property is not found, this value will be used instead.").exampleJson((JsonElement)new JsonPrimitive((Number)0));
            AbstractIntegerTextureVariable.addDocumentationFields(builder);
        }

        @Override
        public class_2960 getId() {
            return Palladium.id("integer_property");
        }
    }
}

