/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.model.animation;

import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_572;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.threetag.palladium.client.model.animation.PalladiumAnimation;
import net.threetag.palladium.entity.FlightHandler;
import net.threetag.palladium.entity.PalladiumPlayerExtension;
import net.threetag.palladium.util.Easing;
import net.threetag.palladiumcore.event.ViewportEvents;

@Environment(value=EnvType.CLIENT)
public class FlightAnimation
extends PalladiumAnimation
implements ViewportEvents.ComputeCameraAngles {
    public FlightAnimation(int priority) {
        super(priority);
        ViewportEvents.COMPUTE_CAMERA_ANGLES.register((Object)this);
    }

    @Override
    public void animate(PalladiumAnimation.Builder builder, class_742 player, class_572<?> model, PalladiumAnimation.FirstPersonContext firstPersonContext, float partialTicks) {
        boolean active;
        boolean bl = active = !firstPersonContext.firstPerson();
        if (active && player instanceof PalladiumPlayerExtension) {
            PalladiumPlayerExtension extension = (PalladiumPlayerExtension)player;
            FlightHandler flight = extension.palladium$getFlightHandler();
            float anim = flight.getFlightAnimation(partialTicks);
            if (anim <= 1.0f) {
                return;
            }
            anim = (anim - 1.0f) / 2.0f;
            class_241 vec1 = FlightAnimation.to2D(flight.getFlightVector(partialTicks));
            class_241 vec2 = FlightAnimation.to2D(flight.getLookAngle(partialTicks));
            double tilt = class_3532.method_15350((double)FlightAnimation.angleBetweenVector(vec1, vec2), (double)-0.5, (double)0.5) * 90.0 * (double)flight.getHorizontalSpeed(partialTicks);
            builder.get(PalladiumAnimation.PlayerModelPart.BODY).setZRotDegrees((float)(-tilt)).setXRotDegrees(-90.0f - player.method_36455()).setY(3.2f).setY2(-14.4f).animate(Easing.INBACK, anim);
            builder.get(PalladiumAnimation.PlayerModelPart.HEAD).setXRotDegrees(-90.0f).setYRotDegrees((float)tilt).animate(Easing.INBACK, anim);
            builder.get(PalladiumAnimation.PlayerModelPart.CHEST).setXRotDegrees(-5.0f).setYRotDegrees(0.0f).setZRotDegrees(0.0f).animate(Easing.INOUTCUBIC, anim);
            builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_ARM).setXRotDegrees(0.0f).setYRotDegrees(17.5f).setZRotDegrees(5.0f).animate(Easing.INOUTCUBIC, anim);
            builder.get(PalladiumAnimation.PlayerModelPart.LEFT_ARM).setXRotDegrees(0.0f).setYRotDegrees(-17.5f).setZRotDegrees(-5.0f).animate(Easing.INOUTCUBIC, anim);
            builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_LEG).resetX().resetY().setZ(-1.0f).setXRotDegrees(5.0f).setYRotDegrees(2.5f).setZRotDegrees(2.5f).animate(Easing.INOUTCUBIC, anim);
            builder.get(PalladiumAnimation.PlayerModelPart.LEFT_LEG).resetX().resetY().setZ(-1.0f).setXRotDegrees(5.0f).setYRotDegrees(-2.5f).setZRotDegrees(-2.5f).animate(Easing.INOUTCUBIC, anim);
            if (FlightHandler.getAnimationType((class_1309)player) == FlightHandler.FlightAnimationType.HEROIC) {
                if (player.method_6068() == class_1306.field_6183) {
                    builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_ARM).setXRotDegrees(-180.0f).setYRotDegrees(0.0f).setZRotDegrees(-15.0f);
                } else {
                    builder.get(PalladiumAnimation.PlayerModelPart.LEFT_ARM).setXRotDegrees(-180.0f).setYRotDegrees(0.0f).setZRotDegrees(15.0f);
                }
            }
        }
    }

    public static class_241 to2D(class_243 vec) {
        return new class_241((float)vec.field_1352, (float)vec.field_1350);
    }

    public static double angleBetweenVector(class_241 vec1, class_241 vec2) {
        return Math.atan2(vec1.field_1343 * vec2.field_1342 - vec1.field_1342 * vec2.field_1343, vec1.field_1343 * vec2.field_1343 + vec1.field_1342 * vec2.field_1342);
    }

    public void computeCameraAngles(class_757 gameRenderer, class_4184 camera, double partialTick, AtomicReference<Float> yaw, AtomicReference<Float> pitch, AtomicReference<Float> roll) {
        class_746 class_7463 = class_310.method_1551().field_1724;
        if (class_7463 instanceof PalladiumPlayerExtension) {
            PalladiumPlayerExtension extension = (PalladiumPlayerExtension)class_7463;
            FlightHandler flight = extension.palladium$getFlightHandler();
            float anim = flight.getFlightAnimation((float)partialTick);
            if (anim <= 1.0f) {
                return;
            }
            anim = (anim - 1.0f) / 2.0f;
            class_241 vec1 = FlightAnimation.to2D(flight.getFlightVector((float)partialTick));
            class_241 vec2 = FlightAnimation.to2D(flight.getLookAngle((float)partialTick));
            double tilt = class_3532.method_15350((double)FlightAnimation.angleBetweenVector(vec1, vec2), (double)-0.5, (double)0.5) * 30.0 * (double)flight.getHorizontalSpeed((float)partialTick);
            roll.set(Float.valueOf((float)tilt * Easing.INOUTCUBIC.apply(anim)));
        }
    }
}

