/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.entity;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_746;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.renderer.entity.PlayerSkinInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerSkinFetcher {
    private static final Map<String, GameProfile> CACHED_NAME_PROFILES = new ConcurrentHashMap<String, GameProfile>();
    private static final Map<String, PlayerSkinInfo> CACHED_NAME_SKINS = new ConcurrentHashMap<String, PlayerSkinInfo>();
    private static final Pattern UUID_PATTERN = Pattern.compile("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})");
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();

    @Nullable
    public static class_2960 getOrLoadPlayerSkin(String username) {
        PlayerSkinInfo PlayerSkinInfo2 = PlayerSkinFetcher.getPlayerSkinInfo(username);
        if (PlayerSkinInfo2.hasFailed() || PlayerSkinInfo2.isLoading()) {
            return null;
        }
        return PlayerSkinInfo2.getTexture();
    }

    @Nullable
    public static String getOrLoadModelType(String username) {
        PlayerSkinInfo PlayerSkinInfo2 = PlayerSkinFetcher.getPlayerSkinInfo(username);
        if (PlayerSkinInfo2.hasFailed() || PlayerSkinInfo2.isLoading()) {
            return null;
        }
        return PlayerSkinInfo2.getModelName();
    }

    @Nullable
    public static PlayerSkinInfo getLoadedPlayerSkinInfo(@NotNull String username) {
        PlayerSkinInfo PlayerSkinInfo2 = PlayerSkinFetcher.getPlayerSkinInfo(username);
        if (PlayerSkinInfo2.hasFailed() || PlayerSkinInfo2.isLoading()) {
            return null;
        }
        return PlayerSkinInfo2;
    }

    public static PlayerSkinInfo getPlayerSkinInfo(@NotNull String username) {
        class_746 mcPlayer = class_310.method_1551().field_1724;
        if (mcPlayer != null && username.equalsIgnoreCase(mcPlayer.method_7334().getName())) {
            return CACHED_NAME_SKINS.computeIfAbsent(username.toLowerCase(Locale.ROOT), s -> {
                PlayerSkinInfo PlayerSkinInfo2 = new PlayerSkinInfo();
                PlayerSkinInfo2.set(mcPlayer.method_3121(), mcPlayer.method_3117());
                return PlayerSkinInfo2;
            });
        }
        return CACHED_NAME_SKINS.computeIfAbsent(username.toLowerCase(Locale.ROOT), key -> {
            class_156.method_18349().execute(() -> {
                GameProfile profile = PlayerSkinFetcher.getGameProfile(username);
                if (profile != null) {
                    class_310.method_1551().method_1582().method_4652(profile, (type, resourceLocation, minecraftProfileTexture) -> {
                        if (type == MinecraftProfileTexture.Type.SKIN) {
                            String skinModel = minecraftProfileTexture.getMetadata("model");
                            if (skinModel == null) {
                                skinModel = "default";
                            }
                            CACHED_NAME_SKINS.computeIfAbsent(profile.getName().toLowerCase(Locale.ROOT), n -> new PlayerSkinInfo()).set(skinModel, resourceLocation);
                        }
                    }, true);
                } else {
                    CACHED_NAME_SKINS.computeIfAbsent(username.toLowerCase(Locale.ROOT), n -> new PlayerSkinInfo()).setFailed();
                }
            });
            return new PlayerSkinInfo();
        });
    }

    @Nullable
    public static GameProfile getGameProfile(@NotNull String name) {
        return CACHED_NAME_PROFILES.computeIfAbsent(name, key -> {
            JsonObject object = PlayerSkinFetcher.parseURL("https://api.mojang.com/users/profiles/minecraft/" + key + "?unsigned=false");
            if (object == null) {
                return null;
            }
            UUID uuid = PlayerSkinFetcher.fromStringWithoutDashes(class_3518.method_15265((JsonObject)object, (String)"id"));
            String realName = class_3518.method_15265((JsonObject)object, (String)"name");
            return new GameProfile(uuid, realName);
        });
    }

    @Nullable
    private static JsonObject parseURL(@NotNull String purl) {
        try {
            URI uri = new URI(purl);
            HttpRequest request = HttpRequest.newBuilder(uri).GET().build();
            HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IllegalStateException("Failed to do an HTTP request to: " + purl + " Response code: " + response.statusCode());
            }
            String responseBody = response.body();
            return JsonParser.parseString((String)responseBody).getAsJsonObject();
        }
        catch (Exception e) {
            Palladium.LOGGER.warn("Failed to fetch URL: {}", (Object)purl);
            return null;
        }
    }

    private static UUID fromStringWithoutDashes(@NotNull String uuid) {
        String correctedUUID = UUID_PATTERN.matcher(uuid).replaceAll("$1-$2-$3-$4-$5");
        return UUID.fromString(correctedUUID);
    }
}

