/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.renderlayer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_3518;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.threetag.palladium.client.renderer.renderlayer.AbstractPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerManager;
import net.threetag.palladium.entity.BodyPart;
import net.threetag.palladium.util.context.DataContext;

public final class CompoundPackRenderLayer
extends AbstractPackRenderLayer {
    private final List<IPackRenderLayer> layers;

    public CompoundPackRenderLayer(List<IPackRenderLayer> layers) {
        this.layers = layers;
    }

    @Override
    public void render(DataContext context, class_4587 poseStack, class_4597 bufferSource, class_583<class_1297> parentModel, int packedLight, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (IPackRenderLayer.conditionsFulfilled(context.getEntity(), this.conditions, this.thirdPersonConditions)) {
            for (IPackRenderLayer layer : this.layers) {
                layer.render(context, poseStack, bufferSource, parentModel, packedLight, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
        }
    }

    @Override
    public void renderArm(DataContext context, class_1306 arm, class_1007 playerRenderer, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        if (IPackRenderLayer.conditionsFulfilled(context.getEntity(), this.conditions, this.firstPersonConditions)) {
            for (IPackRenderLayer layer : this.layers) {
                layer.renderArm(context, arm, playerRenderer, poseStack, bufferSource, packedLight);
            }
        }
    }

    @Override
    public List<BodyPart> getHiddenBodyParts(class_1309 entity) {
        ArrayList<BodyPart> bodyParts = new ArrayList<BodyPart>();
        if (IPackRenderLayer.conditionsFulfilled((class_1297)entity, this.conditions, this.thirdPersonConditions)) {
            for (IPackRenderLayer layer : this.layers) {
                for (BodyPart hiddenBodyPart : layer.getHiddenBodyParts(entity)) {
                    if (bodyParts.contains((Object)hiddenBodyPart)) continue;
                    bodyParts.add(hiddenBodyPart);
                }
            }
        }
        return bodyParts;
    }

    @Override
    public void createSnapshot(DataContext context, class_583<class_1297> parentModel, Consumer<IPackRenderLayer.Snapshot> consumer) {
        for (IPackRenderLayer layer : this.layers) {
            layer.createSnapshot(context, parentModel, consumer);
        }
    }

    public static CompoundPackRenderLayer parse(JsonObject json) {
        JsonArray list = class_3518.method_15261((JsonObject)json, (String)"layers");
        ArrayList<IPackRenderLayer> layers = new ArrayList<IPackRenderLayer>();
        for (JsonElement el : list) {
            layers.add(PackRenderLayerManager.parseLayer(el.getAsJsonObject()));
        }
        return new CompoundPackRenderLayer(layers);
    }

    public List<IPackRenderLayer> layers() {
        return this.layers;
    }

    @Override
    public boolean isOrContains(IPackRenderLayer layer) {
        if (super.isOrContains(layer)) {
            return true;
        }
        for (IPackRenderLayer child : this.layers) {
            if (!child.isOrContains(layer)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CompoundPackRenderLayer that = (CompoundPackRenderLayer)obj;
        return Objects.equals(this.layers, that.layers);
    }

    public int hashCode() {
        return Objects.hash(this.layers);
    }

    public String toString() {
        return "CompoundPackRenderLayer[layers=" + String.valueOf(this.layers) + "]";
    }
}

