/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.renderlayer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5597;
import net.minecraft.class_5603;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.threetag.palladium.client.renderer.entity.HumanoidRendererModifications;
import net.threetag.palladium.client.renderer.renderlayer.RenderLayerStates;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionEnvironment;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.FalseCondition;
import net.threetag.palladium.condition.TrueCondition;
import net.threetag.palladium.entity.BodyPart;
import net.threetag.palladium.mixin.client.AgeableListModelInvoker;
import net.threetag.palladium.util.context.DataContext;

public interface IPackRenderLayer {
    public void render(DataContext var1, class_4587 var2, class_4597 var3, class_583<class_1297> var4, int var5, float var6, float var7, float var8, float var9, float var10, float var11);

    default public void renderArm(DataContext context, class_1306 arm, class_1007 playerRenderer, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
    }

    public IPackRenderLayer addCondition(Condition var1, PerspectiveConditionContext var2);

    public List<BodyPart> getHiddenBodyParts(class_1309 var1);

    default public void onLoad() {
    }

    default public void onUnload() {
    }

    default public boolean isOrContains(IPackRenderLayer layer) {
        return this == layer;
    }

    default public RenderLayerStates.State createState() {
        return null;
    }

    default public void createSnapshot(DataContext context, class_583<class_1297> parentModel, Consumer<Snapshot> consumer) {
    }

    public static <T extends IPackRenderLayer> T parseConditions(T layer, JsonObject json) {
        for (PerspectiveConditionContext context : PerspectiveConditionContext.values()) {
            if (!class_3518.method_15294((JsonObject)json, (String)context.key)) continue;
            JsonElement el = json.get(context.key);
            if (el.isJsonPrimitive()) {
                boolean result = el.getAsBoolean();
                layer.addCondition(result ? new TrueCondition() : new FalseCondition(), context);
                continue;
            }
            ConditionSerializer.listFromJSON(el, ConditionEnvironment.ASSETS).forEach(cond -> layer.addCondition((Condition)cond, context));
        }
        return layer;
    }

    public static boolean conditionsFulfilled(class_1297 entity, List<Condition> conditions) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            for (Condition condition : conditions) {
                if (condition.active(DataContext.forEntity((class_1297)livingEntity))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean conditionsFulfilled(class_1297 entity, List<Condition> bothConditions, List<Condition> specificConditions) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            for (Condition condition : bothConditions) {
                if (condition.active(DataContext.forEntity((class_1297)livingEntity))) continue;
                return false;
            }
            for (Condition condition : specificConditions) {
                if (condition.active(DataContext.forEntity((class_1297)livingEntity))) continue;
                return false;
            }
        }
        return true;
    }

    public static void copyModelProperties(class_1297 entity, class_572 parent, class_572 child) {
        parent.method_2818(child);
        if (entity instanceof class_1531) {
            class_1531 armorStand = (class_1531)entity;
            child.field_3398.field_3654 = (float)Math.PI / 180 * armorStand.method_6921().method_10256();
            child.field_3398.field_3675 = (float)Math.PI / 180 * armorStand.method_6921().method_10257();
            child.field_3398.field_3674 = (float)Math.PI / 180 * armorStand.method_6921().method_10258();
            child.field_3391.field_3654 = (float)Math.PI / 180 * armorStand.method_6923().method_10256();
            child.field_3391.field_3675 = (float)Math.PI / 180 * armorStand.method_6923().method_10257();
            child.field_3391.field_3674 = (float)Math.PI / 180 * armorStand.method_6923().method_10258();
            child.field_27433.field_3654 = (float)Math.PI / 180 * armorStand.method_6930().method_10256();
            child.field_27433.field_3675 = (float)Math.PI / 180 * armorStand.method_6930().method_10257();
            child.field_27433.field_3674 = (float)Math.PI / 180 * armorStand.method_6930().method_10258();
            child.field_3401.field_3654 = (float)Math.PI / 180 * armorStand.method_6903().method_10256();
            child.field_3401.field_3675 = (float)Math.PI / 180 * armorStand.method_6903().method_10257();
            child.field_3401.field_3674 = (float)Math.PI / 180 * armorStand.method_6903().method_10258();
            child.field_3397.field_3654 = (float)Math.PI / 180 * armorStand.method_6917().method_10256();
            child.field_3397.field_3675 = (float)Math.PI / 180 * armorStand.method_6917().method_10257();
            child.field_3397.field_3674 = (float)Math.PI / 180 * armorStand.method_6917().method_10258();
            child.field_3392.field_3654 = (float)Math.PI / 180 * armorStand.method_6900().method_10256();
            child.field_3392.field_3675 = (float)Math.PI / 180 * armorStand.method_6900().method_10257();
            child.field_3392.field_3674 = (float)Math.PI / 180 * armorStand.method_6900().method_10258();
            child.field_3394.method_17138(child.field_3398);
        }
        child.method_2805(true);
        HumanoidRendererModifications.applyRemovedBodyParts(child);
    }

    public static enum PerspectiveConditionContext {
        BOTH("conditions"),
        FIRST_PERSON("first_person_conditions"),
        THIRD_PERSON("third_person_conditions");

        public final String key;

        private PerspectiveConditionContext(String key) {
            this.key = key;
        }
    }

    public static class Snapshot {
        private final class_583<?> model;
        private final class_2960 texture;
        private final Map<class_630, class_5603> poseMap;

        public Snapshot(class_583<?> model, class_2960 texture) {
            block4: {
                block3: {
                    this.poseMap = new HashMap<class_630, class_5603>();
                    this.model = model;
                    this.texture = texture;
                    if (!(model instanceof AgeableListModelInvoker)) break block3;
                    AgeableListModelInvoker ageable = (AgeableListModelInvoker)model;
                    for (class_630 part : ageable.invokeHeadParts()) {
                        this.storePose(part);
                    }
                    for (class_630 part : ageable.invokeBodyParts()) {
                        this.storePose(part);
                    }
                    break block4;
                }
                if (!(model instanceof class_5597)) break block4;
                class_5597 hierarchical = (class_5597)model;
                for (class_630 part : hierarchical.method_32008().field_3661.values()) {
                    this.storePose(part);
                }
            }
        }

        private void storePose(class_630 part) {
            this.poseMap.put(part, part.method_32084());
            for (class_630 child : part.field_3661.values()) {
                this.storePose(child);
            }
        }

        public void applyPoses() {
            for (Map.Entry<class_630, class_5603> e : this.poseMap.entrySet()) {
                e.getKey().method_32085(e.getValue());
            }
        }

        public class_583<?> getModel() {
            return this.model;
        }

        public class_2960 getTexture() {
            return this.texture;
        }
    }
}

