/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.renderlayer;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_918;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.parser.AddonParser;
import net.threetag.palladium.client.renderer.PalladiumRenderTypes;
import net.threetag.palladium.client.renderer.item.armor.ArmorRendererData;
import net.threetag.palladium.client.renderer.renderlayer.AbstractPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.CompoundPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.LightningSparksRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.RenderTypeFunction;
import net.threetag.palladium.client.renderer.renderlayer.SkinOverlayPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.ThrusterPackRenderLayer;
import net.threetag.palladium.entity.BodyPart;
import net.threetag.palladium.item.ArmorWithRenderer;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.power.ability.RenderLayerProviderAbility;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;

public class PackRenderLayerManager
extends class_4309 {
    private static PackRenderLayerManager INSTANCE;
    private static final List<Provider> RENDER_LAYERS_PROVIDERS;
    private static final Map<class_2960, Function<JsonObject, IPackRenderLayer>> RENDER_LAYERS_PARSERS;
    private static final Map<class_2960, RenderTypeFunction> RENDER_TYPES;
    private Map<class_2960, IPackRenderLayer> renderLayers = new HashMap<class_2960, IPackRenderLayer>();

    public PackRenderLayerManager() {
        super(AddonParser.GSON, "palladium/render_layers");
        INSTANCE = this;
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        this.renderLayers.values().forEach(IPackRenderLayer::onUnload);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        object.forEach((resourceLocation, jsonElement) -> {
            try {
                IPackRenderLayer layer = PackRenderLayerManager.parseLayer(class_3518.method_15295((JsonElement)jsonElement, (String)"$"));
                builder.put(resourceLocation, (Object)layer);
            }
            catch (Exception e) {
                AddonPackLog.error("Parsing error loading render layer {}", resourceLocation, e);
            }
        });
        this.renderLayers = builder.build();
        this.renderLayers.values().forEach(IPackRenderLayer::onLoad);
    }

    public IPackRenderLayer getLayer(class_2960 id) {
        return this.renderLayers.get(id);
    }

    public static IPackRenderLayer parseLayer(JsonObject json) {
        class_2960 parserId = GsonUtil.getAsResourceLocation(json, "type", new class_2960("palladium", "default"));
        if (!RENDER_LAYERS_PARSERS.containsKey(parserId)) {
            throw new JsonParseException("Unknown render layer type '" + String.valueOf(parserId) + "'");
        }
        IPackRenderLayer layer = IPackRenderLayer.parseConditions(RENDER_LAYERS_PARSERS.get(parserId).apply(json), json);
        if (layer instanceof AbstractPackRenderLayer) {
            AbstractPackRenderLayer abstractPackRenderLayer = (AbstractPackRenderLayer)layer;
            GsonUtil.ifHasKey(json, "hidden_body_parts", el -> {
                if (el.isJsonPrimitive()) {
                    String string = el.getAsString();
                    if (string.equalsIgnoreCase("all")) {
                        for (BodyPart bodyPart : BodyPart.values()) {
                            abstractPackRenderLayer.addHiddenBodyPart(bodyPart);
                        }
                    } else {
                        abstractPackRenderLayer.addHiddenBodyPart(BodyPart.fromJson(string));
                    }
                } else if (el.isJsonArray()) {
                    JsonArray jsonArray = el.getAsJsonArray();
                    for (JsonElement jsonElement : jsonArray) {
                        abstractPackRenderLayer.addHiddenBodyPart(BodyPart.fromJson(jsonElement.getAsString()));
                    }
                } else {
                    throw new JsonParseException("hidden_body_parts setting must either be a string or an array");
                }
            });
        }
        return layer;
    }

    public static PackRenderLayerManager getInstance() {
        return INSTANCE;
    }

    public static void registerProvider(Provider provider) {
        RENDER_LAYERS_PROVIDERS.add(provider);
    }

    public static void registerParser(class_2960 id, Function<JsonObject, IPackRenderLayer> function) {
        RENDER_LAYERS_PARSERS.put(id, function);
    }

    public static void registerRenderType(class_2960 id, RenderTypeFunction function) {
        RENDER_TYPES.put(id, function);
    }

    public static RenderTypeFunction getRenderType(class_2960 id) {
        return RENDER_TYPES.get(id);
    }

    public static void forEachLayer(class_1297 entity, BiConsumer<DataContext, IPackRenderLayer> consumer) {
        for (Provider provider : RENDER_LAYERS_PROVIDERS) {
            provider.addRenderLayers(entity, consumer);
        }
    }

    static {
        RENDER_LAYERS_PROVIDERS = new ArrayList<Provider>();
        RENDER_LAYERS_PARSERS = new HashMap<class_2960, Function<JsonObject, IPackRenderLayer>>();
        RENDER_TYPES = new HashMap<class_2960, RenderTypeFunction>();
        PackRenderLayerManager.registerProvider((entity, layers) -> {
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                PackRenderLayerManager manager = PackRenderLayerManager.getInstance();
                for (AbilityInstance entry : AbilityUtil.getEnabledRenderLayerInstances(livingEntity)) {
                    IPackRenderLayer layer = ((RenderLayerProviderAbility)((Object)entry.getConfiguration().getAbility())).getRenderLayer(entry, livingEntity, manager);
                    if (layer == null) continue;
                    layers.accept(DataContext.forAbility(livingEntity, entry), layer);
                }
            }
        });
        PackRenderLayerManager.registerProvider((entity, layers) -> {
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                for (class_1304 slot : class_1304.values()) {
                    ArmorWithRenderer armorWithRenderer;
                    Object patt4176$temp;
                    class_1792 patt4083$temp;
                    IAddonItem addonItem;
                    class_1799 stack = livingEntity.method_6118(slot);
                    if (stack.method_7960()) continue;
                    DataContext context = DataContext.forArmorInSlot(livingEntity, slot);
                    class_1792 patt3449$temp = stack.method_7909();
                    if (patt3449$temp instanceof IAddonItem && (addonItem = (IAddonItem)patt3449$temp).getRenderLayerContainer() != null) {
                        IAddonItem.RenderLayerContainer container = addonItem.getRenderLayerContainer();
                        for (class_2960 id : container.get(slot.method_5923())) {
                            IPackRenderLayer layer = PackRenderLayerManager.getInstance().getLayer(id);
                            if (layer == null) continue;
                            layers.accept(context, layer);
                        }
                    }
                    if (!slot.method_46643() || !((patt4083$temp = stack.method_7909()) instanceof ArmorWithRenderer) || !((patt4176$temp = (armorWithRenderer = (ArmorWithRenderer)patt4083$temp).getCachedArmorRenderer()) instanceof ArmorRendererData)) continue;
                    ArmorRendererData renderer = (ArmorRendererData)patt4176$temp;
                    for (IPackRenderLayer layer : renderer.getRenderLayers()) {
                        layers.accept(context, layer);
                    }
                }
            }
        });
        PackRenderLayerManager.registerParser(new class_2960("palladium", "default"), PackRenderLayer::parse);
        PackRenderLayerManager.registerParser(new class_2960("palladium", "compound"), CompoundPackRenderLayer::parse);
        PackRenderLayerManager.registerParser(new class_2960("palladium", "skin_overlay"), SkinOverlayPackRenderLayer::parse);
        PackRenderLayerManager.registerParser(new class_2960("palladium", "lightning_sparks"), LightningSparksRenderLayer::parse);
        PackRenderLayerManager.registerParser(new class_2960("palladium", "thrusters"), ThrusterPackRenderLayer::parse);
        PackRenderLayerManager.registerRenderType(new class_2960("minecraft", "solid"), (source, texture, glint) -> class_918.method_27952((class_4597)source, (class_1921)class_1921.method_23580((class_2960)texture), (boolean)false, (boolean)glint));
        PackRenderLayerManager.registerRenderType(new class_2960("minecraft", "cutout"), (source, texture, glint) -> class_918.method_27952((class_4597)source, (class_1921)class_1921.method_23576((class_2960)texture), (boolean)false, (boolean)glint));
        PackRenderLayerManager.registerRenderType(new class_2960("minecraft", "glow"), new RenderTypeFunction(){

            @Override
            public class_4588 createVertexConsumer(class_4597 buffer, class_2960 texture, boolean withGlint) {
                return class_918.method_27952((class_4597)buffer, (class_1921)PalladiumRenderTypes.getGlowing(texture), (boolean)false, (boolean)withGlint);
            }

            @Override
            public int getPackedLight(int packedLight) {
                return 0xF00000;
            }
        });
    }

    public static interface Provider {
        public void addRenderLayers(class_1297 var1, BiConsumer<DataContext, IPackRenderLayer> var2);
    }
}

