/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.renderlayer;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.awt.Color;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.threetag.palladium.client.dynamictexture.DynamicTexture;
import net.threetag.palladium.client.dynamictexture.DynamicTextureManager;
import net.threetag.palladium.client.renderer.DynamicColor;
import net.threetag.palladium.client.renderer.renderlayer.AbstractPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerManager;
import net.threetag.palladium.client.renderer.renderlayer.RenderTypeFunction;
import net.threetag.palladium.util.SkinTypedValue;
import net.threetag.palladium.util.context.DataContext;

public class SkinOverlayPackRenderLayer
extends AbstractPackRenderLayer {
    private final SkinTypedValue<DynamicTexture> texture;
    private final RenderTypeFunction renderType;
    private final DynamicColor tint;

    public SkinOverlayPackRenderLayer(SkinTypedValue<DynamicTexture> texture, RenderTypeFunction renderType, DynamicColor tint) {
        this.texture = texture;
        this.renderType = renderType;
        this.tint = tint;
    }

    @Override
    public void render(DataContext context, class_4587 poseStack, class_4597 bufferSource, class_583<class_1297> parentModel, int packedLight, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        class_1297 entity = context.getEntity();
        if (IPackRenderLayer.conditionsFulfilled(entity, this.conditions, this.thirdPersonConditions)) {
            Color tint = Color.WHITE;
            if (this.tint != null) {
                tint = this.tint.getColor(context);
            }
            class_4588 vertexConsumer = this.renderType.createVertexConsumer(bufferSource, this.texture.get(entity).getTexture(context), context.getItem().method_7958());
            parentModel.method_2828(poseStack, vertexConsumer, this.renderType.getPackedLight(packedLight), class_4608.field_21444, (float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f, (float)tint.getAlpha() / 255.0f);
        }
    }

    @Override
    public void renderArm(DataContext context, class_1306 arm, class_1007 playerRenderer, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        class_1297 player = context.getEntity();
        if (IPackRenderLayer.conditionsFulfilled(player, this.conditions, this.firstPersonConditions)) {
            class_591 entityModel = (class_591)playerRenderer.method_4038();
            class_4588 vertexConsumer = this.renderType.createVertexConsumer(bufferSource, this.texture.get(player).getTexture(context), context.getItem().method_7958());
            entityModel.field_3447 = 0.0f;
            entityModel.field_3400 = false;
            entityModel.field_3396 = 0.0f;
            Color tint = Color.WHITE;
            if (this.tint != null) {
                tint = this.tint.getColor(context);
            }
            class_630 armToRender = arm == class_1306.field_6183 ? entityModel.field_3401 : entityModel.field_27433;
            armToRender.field_3654 = 0.0f;
            armToRender.method_22699(poseStack, vertexConsumer, this.renderType.getPackedLight(packedLight), class_4608.field_21444, (float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f, (float)tint.getAlpha() / 255.0f);
        }
    }

    public static SkinOverlayPackRenderLayer parse(JsonObject json) {
        RenderTypeFunction renderType = PackRenderLayerManager.getRenderType(new class_2960(class_3518.method_15253((JsonObject)json, (String)"render_type", (String)"solid")));
        if (renderType == null) {
            throw new JsonParseException("Unknown render type '" + String.valueOf(new class_2960(class_3518.method_15253((JsonObject)json, (String)"render_type", (String)"solid"))) + "'");
        }
        return new SkinOverlayPackRenderLayer(SkinTypedValue.fromJSON(json.get("texture"), DynamicTextureManager::fromJson), renderType, DynamicColor.getFromJson(json, "tint", null));
    }
}

