/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.screen;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import net.minecraft.class_5348;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.client.screen.AbilityBarRenderer;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.context.DataContextType;
import net.threetag.palladiumcore.registry.client.OverlayRegistry;
import org.joml.Matrix4f;

public class AbilityWheelRenderer
implements OverlayRegistry.IngameOverlay {
    private static final float SPACING_BETWEEN = 5.0f;
    public static Wheel CURRENT_WHEEL = null;

    public void render(class_310 minecraft, class_329 gui, class_332 guiGraphics, float partialTicks, int width, int height) {
        if (CURRENT_WHEEL != null) {
            int abilityAmount = AbilityWheelRenderer.CURRENT_WHEEL.abilities.size();
            float outerRadius = 100.0f;
            float innerRadius = 50.0f;
            float centerRadius = (outerRadius + innerRadius) / 2.0f;
            int steps = 90 / abilityAmount;
            TextureReference texture = CURRENT_WHEEL.getTexture();
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416((float)minecraft.method_22683().method_4486() / 2.0f, (float)minecraft.method_22683().method_4502() / 2.0f, 0.0f);
            if (texture != null) {
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_22905(0.78125f, 0.78125f, 1.0f);
                guiGraphics.method_25290(Objects.requireNonNull(texture.getTexture(DataContext.forEntity((class_1297)minecraft.field_1724).with(DataContextType.ABILITY_WHEEL_SELECTION, AbilityWheelRenderer.CURRENT_WHEEL.selected + 1))), -128, -128, 0.0f, 0.0f, 256, 256, 256, 256);
                guiGraphics.method_51448().method_22909();
            }
            for (int i = 0; i < abilityAmount; ++i) {
                boolean selected;
                AbilityInstance ability = AbilityWheelRenderer.CURRENT_WHEEL.abilities.get(i);
                double startAngle = (double)(AbilityWheelRenderer.CURRENT_WHEEL.degreesPerSegment * (float)i) + 2.5 - 90.0 - (double)AbilityWheelRenderer.CURRENT_WHEEL.degreesPerSegment / 2.0;
                double endAngle = (double)(AbilityWheelRenderer.CURRENT_WHEEL.degreesPerSegment * (float)(i + 1)) - 2.5 - 90.0 - (double)AbilityWheelRenderer.CURRENT_WHEEL.degreesPerSegment / 2.0;
                boolean bl = selected = i == AbilityWheelRenderer.CURRENT_WHEEL.selected;
                if (texture == null) {
                    float outerRadius_ = selected ? outerRadius + 15.0f : outerRadius;
                    for (int j = 0; j < steps; ++j) {
                        float g;
                        float r;
                        double angle1 = Math.toRadians(startAngle + (endAngle - startAngle) * (double)j / (double)steps);
                        double angle2 = Math.toRadians(startAngle + (endAngle - startAngle) * (double)(j + 1) / (double)steps);
                        class_241 outer1 = new class_241((float)Math.cos(angle1) * outerRadius_, (float)Math.sin(angle1) * outerRadius_);
                        class_241 outer2 = new class_241((float)Math.cos(angle2) * outerRadius_, (float)Math.sin(angle2) * outerRadius_);
                        class_241 inner1 = new class_241((float)Math.cos(angle1) * innerRadius, (float)Math.sin(angle1) * innerRadius);
                        class_241 inner2 = new class_241((float)Math.cos(angle2) * innerRadius, (float)Math.sin(angle2) * innerRadius);
                        float f = selected ? (ability.isUnlocked() ? 1.0f : 0.5f) : (r = 0.0f);
                        float f2 = selected ? (ability.isUnlocked() ? 1.0f : 0.0f) : (g = 0.0f);
                        float b = selected ? (ability.isUnlocked() ? 1.0f : 0.0f) : 0.0f;
                        AbilityWheelRenderer.renderQuad(minecraft, guiGraphics, inner1, inner2, outer2, outer1, r, g, b);
                        guiGraphics.method_25294(-1000, -1000, -999, -999, -16777216);
                    }
                }
                double centerAngle = Math.toRadians((endAngle + startAngle) / 2.0);
                class_241 center = new class_241((float)Math.cos(centerAngle) * centerRadius, (float)Math.sin(centerAngle) * centerRadius);
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_46416((float)((int)center.field_1343), (float)((int)center.field_1342), 0.0f);
                float scale = selected && texture == null ? 1.5f : 1.0f;
                guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
                if (!ability.isUnlocked()) {
                    guiGraphics.method_25302(AbilityBarRenderer.TEXTURE, -8, -8, 42, 74, 18, 18);
                } else {
                    ability.getProperty(Ability.ICON).draw(minecraft, guiGraphics, DataContext.forAbility((class_1309)minecraft.field_1724, ability).with(DataContextType.ABILITY_WHEEL_HOVERED, selected), -8, -8);
                }
                guiGraphics.method_51448().method_22909();
                if (!selected || CURRENT_WHEEL.disablesCenterIcon()) continue;
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_22905(2.0f, 2.0f, 1.0f);
                if (!ability.isUnlocked()) {
                    guiGraphics.method_25302(AbilityBarRenderer.TEXTURE, -8, -8, 42, 74, 18, 18);
                } else {
                    ability.getProperty(Ability.ICON).draw(minecraft, guiGraphics, DataContext.forAbility((class_1309)minecraft.field_1724, ability).with(DataContextType.ABILITY_WHEEL_DISPLAYED, true), -8, -8);
                }
                guiGraphics.method_51448().method_22909();
                class_2561 text = ability.getConfiguration().getDisplayName();
                int length = minecraft.field_1772.method_27525((class_5348)text);
                guiGraphics.method_27535(minecraft.field_1772, ability.getConfiguration().getDisplayName(), -(length / 2), (int)outerRadius + 25, 0xFFFFFF);
            }
            guiGraphics.method_51448().method_22909();
        }
    }

    private static void renderQuad(class_310 minecraft, class_332 guiGraphics, class_241 v1, class_241 v2, class_241 v3, class_241 v4, float r, float g, float b) {
        Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
        class_4588 consumer = minecraft.method_22940().method_23000().getBuffer(class_1921.method_51784());
        float opacity = 0.5f;
        consumer.method_22918(matrix, v1.field_1343, v1.field_1342, 0.0f).method_22915(r, g, b, opacity).method_1344();
        consumer.method_22918(matrix, v2.field_1343, v2.field_1342, 0.0f).method_22915(r, g, b, opacity).method_1344();
        consumer.method_22918(matrix, v3.field_1343, v3.field_1342, 0.0f).method_22915(r, g, b, opacity).method_1344();
        consumer.method_22918(matrix, v4.field_1343, v4.field_1342, 0.0f).method_22915(r, g, b, opacity).method_1344();
    }

    public static void setWheel(Wheel wheel) {
        CURRENT_WHEEL = wheel;
    }

    public static final class Wheel {
        private final List<AbilityInstance> abilities;
        private final TextureReference texture;
        private final boolean disableMouseScrolling;
        private final boolean disableCenterIcon;
        private final float degreesPerSegment;
        private int selected = -1;
        private AbilityInstance selectedAbility = null;
        private double posX = 0.0;
        private double posY = 0.0;

        public Wheel(List<AbilityInstance> abilities, TextureReference texture, boolean disableMouseScrolling, boolean disableCenterIcon) {
            this.abilities = abilities;
            this.degreesPerSegment = 360.0f / (float)abilities.size();
            this.texture = texture;
            this.disableMouseScrolling = disableMouseScrolling;
            this.disableCenterIcon = disableCenterIcon;
        }

        public List<AbilityInstance> abilities() {
            return this.abilities;
        }

        public TextureReference getTexture() {
            return this.texture;
        }

        public boolean disablesMouseScrolling() {
            return this.disableMouseScrolling;
        }

        public boolean disablesCenterIcon() {
            return this.disableCenterIcon;
        }

        public AbilityInstance getSelectedAbility() {
            return this.selectedAbility;
        }

        public void setFromMouseInput(double dx, double dy) {
            double adjustedAngle;
            this.posX = class_3532.method_15350((double)(this.posX + dx), (double)-500.0, (double)500.0);
            this.posY = class_3532.method_15350((double)(this.posY + dy), (double)-500.0, (double)500.0);
            double angle = Math.atan2(this.posY, this.posX);
            for (angle = Math.toDegrees(angle); angle >= 360.0; angle -= 360.0) {
            }
            while (angle < 0.0) {
                angle += 360.0;
            }
            for (adjustedAngle = angle + 2.5 - 180.0 - (double)this.degreesPerSegment / 2.0; adjustedAngle >= 360.0; adjustedAngle -= 360.0) {
            }
            while (adjustedAngle < 0.0) {
                adjustedAngle += 360.0;
            }
            this.selected = class_3532.method_15340((int)((int)(adjustedAngle / (double)this.degreesPerSegment)), (int)0, (int)(this.abilities.size() - 1));
            this.selectedAbility = this.abilities.get(this.selected);
        }

        public void scroll(boolean up) {
            this.selected += up ? 1 : -1;
            if (this.selected < 0) {
                this.selected = this.abilities.size() - 1;
            } else if (this.selected >= this.abilities.size()) {
                this.selected = 0;
            }
            this.selectedAbility = this.abilities.get(class_3532.method_15340((int)this.selected, (int)0, (int)(this.abilities.size() - 1)));
        }
    }
}

