/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.screen.power;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_7706;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import net.threetag.palladium.client.screen.components.IconButton;
import net.threetag.palladium.client.screen.power.ListPowerTab;
import net.threetag.palladium.client.screen.power.PowerTab;
import net.threetag.palladium.client.screen.power.PowerTabType;
import net.threetag.palladium.client.screen.power.TreePowerTab;
import net.threetag.palladium.event.PalladiumClientEvents;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerHandler;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladiumcore.event.ScreenEvents;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class PowersScreen
extends class_437 {
    public static final class_2960 WINDOW = new class_2960("palladium", "textures/gui/powers/window.png");
    public static final class_2960 TABS = new class_2960("palladium", "textures/gui/powers/tabs.png");
    public static final class_2960 WIDGETS = new class_2960("palladium", "textures/gui/powers/widgets.png");
    public static final int WINDOW_WIDTH = 252;
    public static final int WINDOW_HEIGHT = 196;
    public static final int WINDOW_INSIDE_X = 9;
    public static final int WINDOW_INSIDE_Y = 18;
    public static final int WINDOW_INSIDE_WIDTH = 234;
    public static final int WINDOW_INSIDE_HEIGHT = 169;
    private static final int WINDOW_TITLE_X = 8;
    private static final int WINDOW_TITLE_Y = 6;
    public static final int BACKGROUND_TILE_WIDTH = 16;
    public static final int BACKGROUND_TILE_HEIGHT = 16;
    public static final int BACKGROUND_TILE_COUNT_X = 14;
    public static final int BACKGROUND_TILE_COUNT_Y = 7;
    private static final class_2561 VERY_SAD_LABEL = class_2561.method_43471((String)"advancements.sad_label");
    private static final class_2561 NO_ADVANCEMENTS_LABEL = class_2561.method_43471((String)"advancements.empty");
    private static final class_2561 TITLE = class_2561.method_43471((String)"gui.palladium.powers");
    private final List<PowerTab> tabs = new ArrayList<PowerTab>();
    @Nullable
    public PowerTab selectedTab;
    private boolean isScrolling;
    private static int tabPage;
    private static int maxPages;
    public class_437 overlayScreen = null;

    public PowersScreen() {
        super((class_2561)class_2561.method_43473());
    }

    public static void register() {
        ScreenEvents.INIT_POST.register(screen -> {
            Vector2i guiPos = RotatingIconButton.getPos(screen);
            if (guiPos != null) {
                RotatingIconButton button = new RotatingIconButton(guiPos.x, guiPos.y, screen, new ItemIcon(class_1799.field_8037), b -> class_310.method_1551().method_1507((class_437)new PowersScreen()));
                screen.method_37063((class_364)button);
                button.method_47400(class_7919.method_47407((class_2561)TITLE));
            }
        });
    }

    protected void method_25426() {
        this.tabs.clear();
        if (this.selectedTab != null) {
            this.selectedTab.onClosed();
        }
        this.selectedTab = null;
        AtomicInteger i = new AtomicInteger();
        PowerManager.getPowerHandler((class_1309)Objects.requireNonNull(this.field_22787).field_1724).ifPresent(handler -> handler.getPowerHolders().values().stream().sorted(Comparator.comparingInt(holder -> PowerManager.getInstance(false).getPowers().stream().toList().indexOf(holder.getPower()))).forEach(holder -> {
            if (!holder.getPower().isHidden() && holder.getAbilities().values().stream().anyMatch(en -> en.getProperty(Ability.HIDDEN_IN_GUI) == false)) {
                Power.GuiDisplayType type = holder.getPower().getGuiDisplayType();
                if (type == Power.GuiDisplayType.AUTO) {
                    Power.GuiDisplayType guiDisplayType = type = TreePowerTab.canBeTree(holder) ? Power.GuiDisplayType.TREE : Power.GuiDisplayType.LIST;
                }
                if (type == Power.GuiDisplayType.TREE) {
                    this.tabs.add(TreePowerTab.create(this.field_22787, this, i.getAndIncrement(), holder));
                } else {
                    this.tabs.add(ListPowerTab.create(this.field_22787, this, i.getAndIncrement(), holder));
                }
            }
        }));
        if (this.tabs.size() > PowerTabType.MAX_TABS) {
            int guiLeft = (this.field_22789 - 252) / 2;
            int guiTop = (this.field_22790 - 196) / 2;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"<"), b -> {
                tabPage = Math.max(tabPage - 1, 0);
            }).method_46434(guiLeft, guiTop - 50, 20, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)">"), b -> {
                tabPage = Math.min(tabPage + 1, maxPages);
            }).method_46434(guiLeft + 252 - 20, guiTop - 50, 20, 20).method_46431());
            maxPages = this.tabs.size() / PowerTabType.MAX_TABS;
        }
        if (!this.tabs.isEmpty()) {
            this.selectedTab = this.tabs.get(0);
            this.selectedTab.onOpened();
        }
        if (this.overlayScreen != null) {
            this.overlayScreen.method_25423(this.field_22787, this.field_22789, this.field_22790);
        }
    }

    public void method_37066(class_364 listener) {
        super.method_37066(listener);
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int i = (this.field_22789 - 252) / 2;
            int j = (this.field_22790 - 196) / 2;
            if (this.isOverOverlayScreen(mouseX, mouseY)) {
                return this.overlayScreen.method_25402(mouseX, mouseY, button);
            }
            for (PowerTab powerTab : this.tabs) {
                if (!powerTab.isMouseOver(i, j, mouseX, mouseY)) continue;
                if (this.selectedTab != null) {
                    this.selectedTab.onClosed();
                }
                this.selectedTab = powerTab;
                this.selectedTab.onOpened();
                break;
            }
            if (this.selectedTab != null) {
                this.selectedTab.mouseClicked(mouseX, mouseY, button);
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.overlayScreen == null ? super.method_25404(keyCode, scanCode, modifiers) : this.overlayScreen.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int i = (this.field_22789 - 252) / 2;
        int j = (this.field_22790 - 196) / 2;
        this.method_25420(guiGraphics);
        this.renderInside(guiGraphics, mouseX, mouseY, i, j, partialTick);
        this.renderWindow(guiGraphics, i, j);
        this.renderTooltips(guiGraphics, mouseX, mouseY, i, j, partialTick);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.selectedTab != null && this.overlayScreen != null) {
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 500.0f);
            this.overlayScreen.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            this.selectedTab.fade = class_3532.method_15363((float)(this.selectedTab.fade + 0.02f), (float)0.0f, (float)0.5f);
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, -500.0f);
        }
        class_2960 powerId = this.selectedTab != null ? this.selectedTab.powerHolder.getPower().getId() : null;
        ((PalladiumClientEvents.RenderPowerScreen)PalladiumClientEvents.RENDER_POWER_SCREEN.invoker()).renderPowerScreen(this, guiGraphics, mouseX, mouseY, partialTick, powerId);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean inWindow;
        int x1 = (this.field_22789 - 252) / 2 + 9;
        int y1 = (this.field_22790 - 196) / 2 + 18;
        boolean bl = inWindow = mouseX >= (double)x1 && mouseX <= (double)(x1 + 234) && mouseY >= (double)y1 && mouseY <= (double)(y1 + 169);
        if (button != 0) {
            this.isScrolling = false;
            return false;
        }
        if (this.isScrolling || inWindow) {
            if (!this.isScrolling) {
                this.isScrolling = true;
            } else {
                PowerTab powerTab = this.selectedTab;
                if (powerTab instanceof TreePowerTab) {
                    TreePowerTab tree = (TreePowerTab)powerTab;
                    tree.scroll(dragX, dragY);
                }
            }
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isScrolling = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    private void renderInside(class_332 guiGraphics, int mouseX, int mouseY, int offsetX, int offsetY, float partialTick) {
        PowerTab tab = this.selectedTab;
        if (tab == null) {
            guiGraphics.method_25294(offsetX + 9, offsetY + 18, offsetX + 9 + 234, offsetY + 18 + 169, -16777216);
            int i = offsetX + 9 + 117;
            guiGraphics.method_27534(this.field_22793, NO_ADVANCEMENTS_LABEL, i, offsetY + 18 + 56 - 4, -1);
            guiGraphics.method_27534(this.field_22793, VERY_SAD_LABEL, i, offsetY + 18 + 169 - 9, -1);
        } else {
            tab.drawContents(guiGraphics, offsetX + 9, offsetY + 18, mouseX, mouseY, partialTick);
        }
    }

    public void renderWindow(class_332 guiGraphics, int offsetX, int offsetY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        guiGraphics.method_25302(WINDOW, offsetX, offsetY, 0, 0, 252, 196);
        if (this.tabs.size() > 1) {
            RenderSystem.setShaderTexture((int)0, (class_2960)TABS);
            for (PowerTab tab : this.tabs) {
                tab.drawTab(guiGraphics, offsetX, offsetY, tab == this.selectedTab);
            }
            RenderSystem.defaultBlendFunc();
            for (PowerTab tab : this.tabs) {
                tab.drawIcon(guiGraphics, offsetX, offsetY);
            }
            RenderSystem.disableBlend();
        }
        guiGraphics.method_51439(Objects.requireNonNull(this.field_22787).field_1772, TITLE, offsetX + 8, offsetY + 6, 0x404040, false);
    }

    private void renderTooltips(class_332 guiGraphics, int mouseX, int mouseY, int offsetX, int offsetY, float partialTick) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selectedTab != null) {
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416((float)(offsetX + 9), (float)(offsetY + 18), 400.0f);
            this.selectedTab.drawTooltips(guiGraphics, mouseX - offsetX - 9, mouseY - offsetY - 18, offsetX, offsetY, partialTick, this.overlayScreen != null);
            guiGraphics.method_51448().method_22909();
        }
        if (this.tabs.size() > 1) {
            for (PowerTab tab : this.tabs) {
                if (!tab.isMouseOver(offsetX, offsetY, mouseX, mouseY)) continue;
                guiGraphics.method_51438(this.field_22793, tab.getTitle(), mouseX, mouseY);
            }
        }
    }

    public void closeOverlayScreen() {
        this.overlayScreen = null;
    }

    public void openOverlayScreen(class_437 screen) {
        this.closeOverlayScreen();
        this.overlayScreen = screen;
        this.overlayScreen.method_25423(Objects.requireNonNull(this.field_22787), this.field_22789, this.field_22790);
    }

    public boolean isOverOverlayScreen(double mouseX, double mouseY) {
        return this.overlayScreen != null;
    }

    public static class RotatingIconButton
    extends IconButton {
        private final class_437 screen;

        public RotatingIconButton(int x, int y, class_437 screen, IIcon icon, class_4185.class_4241 onPress) {
            super(x, y, icon, onPress, field_40754);
            this.screen = screen;
        }

        @Override
        public IIcon getIcon() {
            ArrayList icons = Lists.newArrayList();
            class_310 mc = class_310.method_1551();
            PowerManager.getPowerHandler((class_1309)mc.field_1724).ifPresent(handler -> handler.getPowerHolders().values().stream().filter(holder -> !holder.getPower().isHidden() && holder.getAbilities().values().stream().anyMatch(en -> en.getProperty(Ability.HIDDEN_IN_GUI) == false)).forEach(holder -> icons.add(holder.getPower().getIcon())));
            if (icons.isEmpty()) {
                this.field_22764 = false;
                icons.add(new ItemIcon((class_1935)class_2246.field_10499));
            } else {
                this.field_22764 = !(this.screen instanceof class_481) || class_481.field_2896 == class_7923.field_44687.method_29107(class_7706.field_40206);
            }
            int i = Objects.requireNonNull(mc.field_1724).field_6012 / 20 % icons.size();
            return (IIcon)icons.get(i);
        }

        public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
            Vector2i pos = RotatingIconButton.getPos(this.screen);
            if (pos != null) {
                this.method_48229(pos.x, pos.y);
            }
            this.field_22763 = this.field_22764 && !PowerManager.getPowerHandler((class_1309)class_310.method_1551().field_1724).orElse(new PowerHandler(null)).getPowerHolders().isEmpty();
            super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }

        public static Vector2i getPos(class_437 screen) {
            if (screen instanceof class_490 || screen.getClass().toString().equals("class top.theillusivec4.curios.client.gui.CuriosScreen")) {
                return new Vector2i(((class_465)screen).field_2776 + 134, screen.field_22790 / 2 - 23);
            }
            if (screen instanceof class_481) {
                return new Vector2i(((class_465)screen).field_2776 + 148, screen.field_22790 / 2 - 50);
            }
            return null;
        }
    }

    @FunctionalInterface
    public static interface RenderCallback {
        public void postRender(PowersScreen var1, class_332 var2, int var3, int var4, float var5, class_2960 var6);
    }
}

