/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.compat.geckolib.renderlayer;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5602;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.compat.geckolib.renderlayer.GeckoLayerState;
import net.threetag.palladium.compat.geckolib.renderlayer.GeckoRenderLayer;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.texture.AnimatableTexture;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.molang.MolangParser;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.util.RenderUtils;

public class GeckoRenderLayerModel
extends class_572<class_742>
implements GeoRenderer<GeckoLayerState> {
    protected final GeoModel<GeckoLayerState> modelProvider;
    protected class_572<?> baseModel;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected class_1297 currentEntity = null;
    protected GeckoLayerState currentState = null;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    public String headBone = "armorHead";
    public String bodyBone = "armorBody";
    public String rightArmBone = "armorRightArm";
    public String leftArmBone = "armorLeftArm";
    public String rightLegBone = "armorRightLeg";
    public String leftLegBone = "armorLeftLeg";
    protected BakedGeoModel lastModel = null;
    protected GeoBone head = null;
    protected GeoBone body = null;
    protected GeoBone rightArm = null;
    protected GeoBone leftArm = null;
    protected GeoBone rightLeg = null;
    protected GeoBone leftLeg = null;

    public GeckoRenderLayerModel(final GeckoRenderLayer renderLayer) {
        super(class_310.method_1551().method_31974().method_32072(class_5602.field_27579));
        this.modelProvider = new GeoModel<GeckoLayerState>(){

            public class_2960 getModelResource(GeckoLayerState animatable) {
                return renderLayer.cachedModel;
            }

            public class_2960 getTextureResource(GeckoLayerState animatable) {
                return renderLayer.cachedTexture;
            }

            public class_2960 getAnimationResource(GeckoLayerState animatable) {
                return renderLayer.animationLocation;
            }

            public void applyMolangQueries(GeckoLayerState animatable, double animTime) {
                MolangParser parser = MolangParser.INSTANCE;
                class_310 mc = class_310.method_1551();
                parser.setMemoizedValue("query.life_time", () -> animTime / 20.0);
                parser.setMemoizedValue("query.actor_count", () -> ((class_638)mc.field_1687).method_18120());
                parser.setMemoizedValue("query.time_of_day", () -> (float)mc.field_1687.method_8532() / 24000.0f);
                parser.setMemoizedValue("query.moon_phase", () -> ((class_638)mc.field_1687).method_30273());
                if (animatable.layer.getModel().currentEntity != null) {
                    class_1297 entity = animatable.layer.getModel().currentEntity;
                    parser.setMemoizedValue("query.distance_from_camera", () -> mc.field_1773.method_19418().method_19326().method_1022(entity.method_19538()));
                    parser.setMemoizedValue("query.is_on_ground", () -> RenderUtils.booleanToFloat((boolean)entity.method_24828()));
                    parser.setMemoizedValue("query.is_in_water", () -> RenderUtils.booleanToFloat((boolean)entity.method_5799()));
                    parser.setMemoizedValue("query.is_in_water_or_rain", () -> RenderUtils.booleanToFloat((boolean)entity.method_5637()));
                    if (entity instanceof class_1309) {
                        class_1309 livingEntity = (class_1309)entity;
                        parser.setMemoizedValue("query.health", () -> ((class_1309)livingEntity).method_6032());
                        parser.setMemoizedValue("query.max_health", () -> ((class_1309)livingEntity).method_6063());
                        parser.setMemoizedValue("query.is_on_fire", () -> RenderUtils.booleanToFloat((boolean)livingEntity.method_5809()));
                        parser.setMemoizedValue("query.ground_speed", () -> {
                            class_243 velocity = livingEntity.method_18798();
                            return class_3532.method_15355((float)((float)(velocity.field_1352 * velocity.field_1352 + velocity.field_1350 * velocity.field_1350)));
                        });
                        parser.setMemoizedValue("query.yaw_speed", () -> livingEntity.method_5705((float)animTime - livingEntity.method_5705((float)animTime - 0.1f)));
                    }
                }
            }
        };
    }

    public long getInstanceId(GeckoLayerState animatable) {
        return super.getInstanceId((GeoAnimatable)animatable) + (long)this.currentEntity.method_5628();
    }

    public void setCurrentRenderingFields(GeckoLayerState state, class_1297 entity, class_572<?> baseModel) {
        this.currentState = state;
        this.baseModel = baseModel;
        this.currentEntity = entity;
    }

    public void preRender(class_4587 poseStack, GeckoLayerState animatable, BakedGeoModel model, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        this.applyBaseModel(this.baseModel);
        this.grabRelevantBones(this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource((GeoAnimatable)this.currentState)));
        this.applyBaseTransformations(this.baseModel);
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    public void method_2828(class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        class_310 mc = class_310.method_1551();
        class_4597.class_4598 bufferSource = mc.field_1769.field_20951.method_23000();
        if (mc.field_1769.method_3270() && mc.method_27022(this.currentEntity)) {
            bufferSource = mc.field_1769.field_20951.method_23003();
        }
        float partialTick = mc.method_1488();
        buffer = this.currentState.layer.renderType.createVertexConsumer((class_4597)bufferSource, this.getTextureLocation(this.currentState), false);
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 1.5f, 0.0f);
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
        AnimationState animationState = new AnimationState((GeoAnimatable)this.currentState, 0.0f, 0.0f, partialTick, false);
        long instanceId = this.getInstanceId(this.currentState);
        animationState.setData(DataTickets.TICK, (Object)this.currentState.getTick(this.currentEntity));
        animationState.setData(DataTickets.ENTITY, (Object)this.currentEntity);
        this.modelProvider.addAdditionalStateData((GeoAnimatable)this.currentState, instanceId, (arg_0, arg_1) -> ((AnimationState)animationState).setData(arg_0, arg_1));
        this.modelProvider.handleAnimations((GeoAnimatable)this.currentState, instanceId, animationState);
        this.defaultRender(poseStack, this.currentState, (class_4597)bufferSource, null, buffer, 0.0f, partialTick, this.currentState.layer.renderType.getPackedLight(packedLight));
        poseStack.method_22909();
    }

    protected void grabRelevantBones(BakedGeoModel bakedModel) {
        if (this.lastModel == bakedModel) {
            return;
        }
        this.lastModel = bakedModel;
        this.head = this.getHeadBone();
        this.body = this.getBodyBone();
        this.rightArm = this.getRightArmBone();
        this.leftArm = this.getLeftArmBone();
        this.rightLeg = this.getRightLegBone();
        this.leftLeg = this.getLeftLegBone();
    }

    protected void applyBaseModel(class_572<?> baseModel) {
        this.field_3448 = baseModel.field_3448;
        this.field_3400 = baseModel.field_3400;
        this.field_3449 = baseModel.field_3449;
        this.field_3395 = baseModel.field_3395;
        this.field_3399 = baseModel.field_3399;
    }

    @Nullable
    public GeoBone getHeadBone() {
        return this.modelProvider.getBone(this.headBone).orElse(null);
    }

    @Nullable
    public GeoBone getBodyBone() {
        return this.modelProvider.getBone(this.bodyBone).orElse(null);
    }

    @Nullable
    public GeoBone getRightArmBone() {
        return this.modelProvider.getBone(this.rightArmBone).orElse(null);
    }

    @Nullable
    public GeoBone getLeftArmBone() {
        return this.modelProvider.getBone(this.leftArmBone).orElse(null);
    }

    @Nullable
    public GeoBone getRightLegBone() {
        return this.modelProvider.getBone(this.rightLegBone).orElse(null);
    }

    @Nullable
    public GeoBone getLeftLegBone() {
        return this.modelProvider.getBone(this.leftLegBone).orElse(null);
    }

    protected void applyBaseTransformations(class_572<?> baseModel) {
        IPackRenderLayer.copyModelProperties(this.currentEntity, baseModel, this);
        if (this.head != null) {
            class_630 headPart = this.field_3398;
            RenderUtils.matchModelPartRot((class_630)headPart, (CoreGeoBone)this.head);
            GeckoRenderLayerModel.copyScaleAndVisibility(headPart, (CoreGeoBone)this.head);
            this.head.updatePosition(headPart.field_3657, -headPart.field_3656, headPart.field_3655);
        }
        if (this.body != null) {
            class_630 bodyPart = this.field_3391;
            RenderUtils.matchModelPartRot((class_630)bodyPart, (CoreGeoBone)this.body);
            GeckoRenderLayerModel.copyScaleAndVisibility(bodyPart, (CoreGeoBone)this.body);
            this.body.updatePosition(bodyPart.field_3657, -bodyPart.field_3656, bodyPart.field_3655);
        }
        if (this.rightArm != null) {
            class_630 rightArmPart = this.field_3401;
            RenderUtils.matchModelPartRot((class_630)rightArmPart, (CoreGeoBone)this.rightArm);
            GeckoRenderLayerModel.copyScaleAndVisibility(rightArmPart, (CoreGeoBone)this.rightArm);
            this.rightArm.updatePosition(rightArmPart.field_3657 + 5.0f, 2.0f - rightArmPart.field_3656, rightArmPart.field_3655);
        }
        if (this.leftArm != null) {
            class_630 leftArmPart = this.field_27433;
            RenderUtils.matchModelPartRot((class_630)leftArmPart, (CoreGeoBone)this.leftArm);
            GeckoRenderLayerModel.copyScaleAndVisibility(leftArmPart, (CoreGeoBone)this.leftArm);
            this.leftArm.updatePosition(leftArmPart.field_3657 - 5.0f, 2.0f - leftArmPart.field_3656, leftArmPart.field_3655);
        }
        if (this.rightLeg != null) {
            class_630 rightLegPart = this.field_3392;
            RenderUtils.matchModelPartRot((class_630)rightLegPart, (CoreGeoBone)this.rightLeg);
            GeckoRenderLayerModel.copyScaleAndVisibility(rightLegPart, (CoreGeoBone)this.rightLeg);
            this.rightLeg.updatePosition(rightLegPart.field_3657 + 2.0f, 12.0f - rightLegPart.field_3656, rightLegPart.field_3655);
        }
        if (this.leftLeg != null) {
            class_630 leftLegPart = this.field_3397;
            RenderUtils.matchModelPartRot((class_630)leftLegPart, (CoreGeoBone)this.leftLeg);
            GeckoRenderLayerModel.copyScaleAndVisibility(leftLegPart, (CoreGeoBone)this.leftLeg);
            this.leftLeg.updatePosition(leftLegPart.field_3657 - 2.0f, 12.0f - leftLegPart.field_3656, leftLegPart.field_3655);
        }
    }

    public static void copyScaleAndVisibility(class_630 from, CoreGeoBone to) {
        to.setScaleX(from.field_37938);
        to.setScaleY(from.field_37939);
        to.setScaleZ(from.field_37940);
        to.setHidden(!from.field_3665);
    }

    public GeoModel<GeckoLayerState> getGeoModel() {
        return this.modelProvider;
    }

    public GeckoLayerState getAnimatable() {
        return this.currentState;
    }

    public void fireCompileRenderLayersEvent() {
    }

    public boolean firePreRenderEvent(class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight) {
        return true;
    }

    public void firePostRenderEvent(class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight) {
    }

    public void updateAnimatedTextureFrame(GeckoLayerState animatable) {
        if (this.currentEntity != null) {
            AnimatableTexture.setAndUpdate((class_2960)this.getTextureLocation(animatable), (int)(this.currentEntity.method_5628() + this.currentEntity.field_6012));
        }
    }
}

