/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.ResourceLocationProperty;

public class AbilityTypeUnlockedCondition
extends Condition {
    private final class_2960 abilityId;

    public AbilityTypeUnlockedCondition(class_2960 abilityId) {
        this.abilityId = abilityId;
    }

    @Override
    public boolean active(DataContext context) {
        class_1309 entity = context.getLivingEntity();
        if (entity == null) {
            return false;
        }
        return AbilityUtil.isTypeUnlocked(entity, this.abilityId);
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.ABILITY_TYPE_UNLOCKED.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<class_2960> ABILITY_TYPE = new ResourceLocationProperty("ability_type").configurable("ID of the ability type to look for. If one ability can be found which is unlocked, the condition will be true");

        public Serializer() {
            this.withProperty(ABILITY_TYPE, Palladium.id("dummy"));
        }

        @Override
        public String getDocumentationDescription() {
            return "Checks if an ability of a certain type is unlocked.";
        }

        @Override
        public Condition make(JsonObject json) {
            return new AbilityTypeUnlockedCondition(this.getProperty(json, ABILITY_TYPE));
        }
    }
}

