/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.threetag.palladium.condition.BuyableCondition;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionEnvironment;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.power.ability.AbilityConfiguration;
import net.threetag.palladium.util.icon.IngredientIcon;
import net.threetag.palladium.util.property.IngredientProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;

public class ItemBuyableCondition
extends BuyableCondition {
    private final class_1856 ingredient;
    private final int amount;

    public ItemBuyableCondition(class_1856 ingredient, int amount) {
        this.ingredient = ingredient;
        this.amount = amount;
    }

    @Override
    public AbilityConfiguration.UnlockData createData() {
        class_1799[] stacks = this.ingredient.method_8105();
        class_5250 component = class_2561.method_43473();
        for (int i = 0; i < stacks.length; ++i) {
            component.method_10852(stacks[i].method_7909().method_7864(stacks[i]));
            if (i >= stacks.length - 1) continue;
            if (i == stacks.length - 2) {
                component.method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"gui.palladium.powers.buy_ability.or")).method_27693(" ");
                continue;
            }
            component.method_27693(", ");
        }
        return new AbilityConfiguration.UnlockData(new IngredientIcon(this.ingredient), this.amount, (class_2561)component);
    }

    @Override
    public boolean isAvailable(class_1309 entity) {
        int found = 0;
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                class_1799 stack = player.method_31548().method_5438(i);
                if (!this.ingredient.method_8093(stack)) continue;
                found += stack.method_7947();
            }
        }
        return found >= this.amount;
    }

    @Override
    public boolean takeFromEntity(class_1309 entity) {
        int remove = this.amount;
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                class_1799 stack = player.method_31548().method_5438(i);
                if (!this.ingredient.method_8093(stack)) continue;
                int willRemove = Math.min(remove, stack.method_7947());
                player.method_31548().method_5434(i, willRemove);
                if ((remove -= willRemove) <= 0) break;
            }
        }
        return remove <= 0;
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.ITEM_BUYABLE.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<class_1856> INGREDIENT = new IngredientProperty("ingredient").configurable("Ingredient predicate for the item");
        public static final PalladiumProperty<Integer> AMOUNT = new IntegerProperty("amount").configurable("Amount of items that the player needs to spend");

        public Serializer() {
            this.withProperty(INGREDIENT, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8620}));
            this.withProperty(AMOUNT, 3);
        }

        @Override
        public ConditionEnvironment getContextEnvironment() {
            return ConditionEnvironment.DATA;
        }

        @Override
        public Condition make(JsonObject json) {
            return new ItemBuyableCondition(this.getProperty(json, INGREDIENT), this.getProperty(json, AMOUNT));
        }

        @Override
        public String getDocumentationDescription() {
            return "The player needs to spend a certain amount of items to unlock the ability.";
        }
    }
}

