/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.documentation;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.documentation.IDocumentedConfigurable;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.Utils;
import net.threetag.palladiumcore.util.Platform;

public class HTMLBuilder {
    public static final File SUBFOLDER = new File("mods/documentation/");
    public final class_2960 id;
    public final String title;
    private HTMLObject html;
    private HTMLObject head;
    private HTMLObject body;
    private boolean hasJson = false;

    public HTMLBuilder(class_2960 id, String title) {
        this(id, title, "https://i.imgur.com/3sx4xJf.png");
    }

    public HTMLBuilder(class_2960 id, String title, String favicon) {
        this.id = id;
        this.title = title;
        this.init(favicon);
    }

    private void init(String favicon) {
        this.head = new HTMLObject("head").add(new HTMLObject("title", this.title)).add(new HTMLObject("style", "table{font-family:arial, sans-serif;border-collapse:collapse;}\ntd,th{border:1px solid #666666;text-align:left;padding:8px;min-width:45px;}\nth{background-color:#CCCCCC;}\np{margin:0;}\ntr:nth-child(even){background-color:#D8D8D8;}\ntr:nth-child(odd){background-color:#EEEEEE;}\ntd.true{background-color:#72FF85AA;}\ntd.false{background-color:#FF6666AA;}\ntd.other{background-color:#42A3FFAA;}\ntd.error{color:#FF0000;}\nth,td.true,td.false,td.other{text-align:center;}pre{outline:1px solid #ccc;padding:5px;margin:5px;} .string{color:green;} .number{color:cornflowerblue;} .boolean{color:darkorange;} .null{color:orangered;} .key{color:purple;}hr { height: 5px; background-color: black }")).add(new HTMLObject("link").addAttribute("rel", "shortcut icon").addAttribute("type", "image/x-icon").addAttribute("href", favicon));
        this.body = new HTMLObject("body");
        this.html = new HTMLObject("html").add(this.head).add(this.body);
    }

    public HTMLBuilder addStyle(String style) {
        this.head.add(new HTMLObject("style", style));
        return this;
    }

    public HTMLBuilder addDocumentation(JsonDocumentationBuilder builder) {
        AtomicBoolean hasExampleJson = new AtomicBoolean(false);
        JsonObject json = new JsonObject();
        HTMLObject div = HTMLBuilder.div(new Object[0]);
        this.add(div);
        if (builder.getTitle() != null) {
            div.add(HTMLBuilder.subHeading(builder.getTitle()));
        }
        if (builder.getDescription() != null) {
            div.add(HTMLBuilder.paragraph(builder.getDescription()));
        }
        div.add(HTMLBuilder.subSubHeading("Settings:")).add(HTMLBuilder.table(Arrays.asList("Setting", "Type", "Description", "Required", "Fallback Value"), builder.getEntries().stream().map(entry -> {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(entry.getName());
            list.add(entry.getTypeClass().getSimpleName());
            list.add(entry.getDescription());
            list.add(entry.isRequired());
            list.add(Utils.orElse(entry.getFallbackValueSerialized(), "/"));
            if (entry.getExampleJson() != null) {
                hasExampleJson.set(true);
                json.add(entry.getName(), entry.getExampleJson());
            }
            return list;
        }).collect(Collectors.toList())));
        if (hasExampleJson.get()) {
            div.add(HTMLBuilder.subSubHeading("Example:")).add(new HTMLObject("pre", json.toString()).addAttribute("class", "json-snippet"));
            this.hasJson = true;
        }
        return this;
    }

    public HTMLBuilder addDocumentationSettings(Collection<IDocumentedConfigurable> settings) {
        return this.addDocumentationSettings(settings, JsonDocumentationBuilder::new);
    }

    public HTMLBuilder addDocumentationSettings(Collection<IDocumentedConfigurable> settings, Supplier<JsonDocumentationBuilder> builderSupplier) {
        HashMap<String, List> sorted = new HashMap<String, List>();
        for (IDocumentedConfigurable setting : settings) {
            Platform.Mod mod2 = Platform.getMod((String)setting.getId().method_12836());
            String modName = mod2 != null ? mod2.name() : setting.getId().method_12836();
            List<IDocumentedConfigurable> modsList = sorted.containsKey(modName) ? (List)sorted.get(modName) : new ArrayList();
            modsList.add(setting);
            sorted.put(modName, modsList);
        }
        HTMLObject overview = HTMLBuilder.paragraph(HTMLBuilder.subHeading("Overview"));
        this.addStyle(".json-block { background-color: lightgray; display: inline-block; border: 5px solid darkgray; padding: 10px }").add(HTMLBuilder.hr()).add(overview);
        sorted.forEach((mod, settingsList) -> {
            overview.add(HTMLBuilder.subSubHeading(mod));
            overview.add(HTMLBuilder.list(settingsList.stream().map(setting -> {
                JsonDocumentationBuilder builder = new JsonDocumentationBuilder();
                setting.generateDocumentation(builder);
                return HTMLBuilder.link(builder.getTitle(), "#" + setting.getId().toString());
            }).collect(Collectors.toList())));
        });
        sorted.values().forEach(modSettings -> modSettings.forEach(arg_0 -> this.lambda$addDocumentationSettings$4((Supplier)builderSupplier, arg_0)));
        return this;
    }

    public HTMLBuilder add(HTMLObject html) {
        this.body.add(html);
        return this;
    }

    public static HTMLObject heading(String heading) {
        return new HTMLObject("h1", heading);
    }

    public static HTMLObject subHeading(String heading) {
        return new HTMLObject("h2", heading);
    }

    public static HTMLObject subSubHeading(String heading) {
        return new HTMLObject("h3", heading);
    }

    public static HTMLObject paragraph(Object ... objects) {
        return new HTMLObject("p", objects);
    }

    public static HTMLObject div(Object ... contents) {
        return new HTMLObject("div", contents);
    }

    public static HTMLObject js(String javascript) {
        return new HTMLObject("script", javascript);
    }

    public static HTMLObject link(Object text, String href) {
        return new HTMLObject("a", text).addAttribute("href", href);
    }

    public static HTMLObject list(Iterable<Object> objects) {
        HTMLObject list = new HTMLObject("ul");
        for (Object object : objects) {
            list.add(new HTMLObject("li", object));
        }
        return list;
    }

    public static HTMLObject numberedList(Iterable<Object> objects) {
        HTMLObject list = new HTMLObject("ol");
        for (Object object : objects) {
            list.add(new HTMLObject("li", object));
        }
        return list;
    }

    public static HTMLObject table(Iterable<?> head, Iterable<Iterable<?>> rows) {
        HTMLObject list = new HTMLObject("table");
        HTMLObject headRow = new HTMLObject("tr");
        list.add(new HTMLObject("thead").add(headRow));
        for (Object obj : head) {
            headRow.add(new HTMLObject("th", obj));
        }
        HTMLObject body = new HTMLObject("tbody");
        list.add(body);
        for (Iterable<?> rowObjects : rows) {
            HTMLObject row = new HTMLObject("tr");
            for (Object obj : rowObjects) {
                if (obj instanceof Boolean) {
                    Boolean b = (Boolean)obj;
                    row.add(new HTMLObject("td", obj).addAttribute("style", "background-color: " + (b != false ? "lightgreen" : "lightcoral")));
                    continue;
                }
                row.add(new HTMLObject("td", obj));
            }
            body.add(row);
        }
        return list;
    }

    public static HTMLObject br() {
        return new HTMLObject("br");
    }

    public static HTMLObject hr() {
        return new HTMLObject("hr");
    }

    public void save() {
        try {
            File file;
            if (this.hasJson) {
                this.add(HTMLBuilder.js("function syntaxHighlight(json) {\n        json = json.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');\n        return json.replace(/(\"(\\\\u[a-zA-Z0-9]{4}|\\\\[^u]|[^\\\\\"])*\"(\\s*:)?|\\b(true|false|null)\\b|-?\\d+(?:\\.\\d*)?(?:[eE][+\\-]?\\d+)?)/g, function (match) {\n            var cls = 'number';\n            if (/^\"/.test(match)) {\n                if (/:$/.test(match)) {\n                    cls = 'key';\n                } else {\n                    cls = 'string';\n                }\n            } else if (/true|false/.test(match)) {\n                cls = 'boolean';\n            } else if (/null/.test(match)) {\n                cls = 'null';\n            }\n            return '<span class=\"' + cls + '\">' + match + '</span>';\n        });\n    }\n\n    const elements = document.getElementsByClassName(\"json-snippet\");\n    const amount = elements.length;\n    for (let i = 0; i < amount; i++) {\n        const element = elements[0];\n        const div = document.createElement(\"pre\");\n        div.innerHTML = syntaxHighlight(JSON.stringify(JSON.parse(element.innerText), undefined, 4));\n        element.parentNode.replaceChild(div, element);\n    }"));
            }
            if (!(file = new File(SUBFOLDER, this.id.method_12836() + "/" + this.id.method_12832() + ".html")).getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write(this.html.toString());
            bw.close();
            Palladium.LOGGER.info("Successfully generated documentation file: " + file.getName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private /* synthetic */ void lambda$addDocumentationSettings$4(Supplier builderSupplier, IDocumentedConfigurable setting) {
        JsonDocumentationBuilder builder = (JsonDocumentationBuilder)builderSupplier.get();
        setting.generateDocumentation(builder);
        JsonObject json = setting.buildExampleJson(new JsonObject(), builder);
        HTMLObject div = HTMLBuilder.div(new Object[0]).setId(setting.getId().toString()).add(HTMLBuilder.subHeading(builder.getTitle()));
        this.add(HTMLBuilder.hr()).add(div);
        if (builder.getDescription() != null) {
            div.add(HTMLBuilder.paragraph(builder.getDescription()));
        }
        if (!builder.getEntries().isEmpty()) {
            div.add(HTMLBuilder.subSubHeading("Settings:")).add(HTMLBuilder.table(Arrays.asList("Setting", "Type", "Description", "Required", "Fallback Value"), builder.getEntries().stream().map(entry -> {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(entry.getName());
                list.add(entry.getTypeClass().getSimpleName());
                list.add(entry.getDescription());
                list.add(entry.isRequired());
                list.add(Utils.orElse(entry.getFallbackValueSerialized(), "/"));
                return list;
            }).collect(Collectors.toList())));
        }
        if (json.keySet().size() > 0) {
            div.add(HTMLBuilder.subSubHeading("Example:")).add(new HTMLObject("pre", json.toString()).addAttribute("class", "json-snippet"));
            this.hasJson = true;
        }
    }

    public static class HTMLObject {
        private final String tag;
        private final List<Object> content = new LinkedList<Object>();
        private final List<Pair<String, String>> attributes = new ArrayList<Pair<String, String>>();

        public HTMLObject(String tag) {
            this(tag, new Object[0]);
        }

        public HTMLObject(String tag, Object ... content) {
            this.tag = tag;
            if (content != null) {
                this.content.addAll(Arrays.asList(content));
            }
        }

        public HTMLObject addAttribute(String key, String value) {
            this.attributes.add((Pair<String, String>)Pair.of((Object)key, (Object)value));
            return this;
        }

        public HTMLObject setId(String id) {
            this.attributes.add((Pair<String, String>)Pair.of((Object)"id", (Object)id));
            return this;
        }

        public HTMLObject add(Object content) {
            this.content.add(content);
            return this;
        }

        public String toString() {
            StringBuilder result = new StringBuilder("<" + this.tag);
            this.attributes.forEach(pair -> result.append(" ").append((String)pair.getFirst()).append("=\"").append((String)pair.getSecond()).append("\""));
            result.append(">").append("\n");
            this.content.forEach(content -> {
                if (content instanceof Supplier) {
                    result.append(((Supplier)content).get().toString());
                } else if (content != null) {
                    if (content instanceof String[]) {
                        Object[] strings = (String[])content;
                        result.append(Arrays.toString(strings));
                    } else {
                        result.append(content);
                    }
                }
            });
            if (!(this.tag.equals("br") || this.tag.equals("hr") || this.tag.equals("link"))) {
                result.append("</").append(this.tag).append(">");
            }
            return result.append("\n").toString();
        }
    }
}

