/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.item;

import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.threetag.palladium.addonpack.parser.ItemParser;
import net.threetag.palladium.addonpack.parser.ToolTierParser;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.item.AddonAttributeContainer;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;

public class AddonHoeItem
extends class_1794
implements IAddonItem {
    private List<class_2561> tooltipLines;
    private IAddonItem.RenderLayerContainer renderLayerContainer = null;
    private final AddonAttributeContainer attributeContainer = new AddonAttributeContainer();
    private boolean shouldRenderModel = true;

    public AddonHoeItem(class_1832 tier, int baseDamage, float attackSpeed, class_1792.class_1793 properties) {
        super(tier, baseDamage, attackSpeed, properties);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        super.method_7851(stack, level, tooltipComponents, isAdvanced);
        if (this.tooltipLines != null) {
            tooltipComponents.addAll(this.tooltipLines);
        }
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return this.attributeContainer.get(PlayerSlot.get(slot), (Multimap<class_1320, class_1322>)super.method_7844(slot));
    }

    @Override
    public AddonAttributeContainer getAttributeContainer() {
        return this.attributeContainer;
    }

    @Override
    public void setTooltip(List<class_2561> lines) {
        this.tooltipLines = lines;
    }

    @Override
    public void setRenderLayerContainer(IAddonItem.RenderLayerContainer container) {
        this.renderLayerContainer = container;
    }

    @Override
    public IAddonItem.RenderLayerContainer getRenderLayerContainer() {
        return this.renderLayerContainer;
    }

    @Override
    public void setShouldRenderModel(boolean shouldRender) {
        this.shouldRenderModel = shouldRender;
    }

    @Override
    public boolean shouldRenderModel() {
        return this.shouldRenderModel;
    }

    public static class Parser
    implements ItemParser.ItemTypeSerializer {
        @Override
        public IAddonItem parse(JsonObject json, class_1792.class_1793 properties) {
            class_1832 tier = ToolTierParser.getToolTier(GsonUtil.getAsResourceLocation(json, "tier"));
            if (tier == null) {
                throw new JsonParseException("Unknown tool tier '" + String.valueOf(GsonUtil.getAsResourceLocation(json, "tier")) + "'");
            }
            return new AddonHoeItem(tier, class_3518.method_15260((JsonObject)json, (String)"base_damage"), class_3518.method_15259((JsonObject)json, (String)"attack_speed"), properties);
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Hoe");
            builder.addProperty("tier", class_1832.class).description("Tool tier, which defines certain characteristics about the tool. Open tool_tiers.html for seeing how to make custom ones. Possible values: " + Arrays.toString(ToolTierParser.getIds().toArray(new class_2960[0]))).required().exampleJson((JsonElement)new JsonPrimitive("minecraft:diamond"));
            builder.addProperty("base_damage", Integer.class).description("Base value for the damage. For reference: iron has -2, diamond has -3").required().exampleJson((JsonElement)new JsonPrimitive((Number)-2));
            builder.addProperty("attack_speed", Float.class).description("Base value for the attack speed. For reference: iron has -1.0, diamond has 0.0").required().exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(-1.0f)));
        }

        @Override
        public class_2960 getId() {
            return new class_2960("palladium", "hoe");
        }
    }
}

