/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import net.minecraft.class_1309;
import net.minecraft.class_2540;
import net.threetag.palladium.condition.BuyableCondition;
import net.threetag.palladium.network.OpenAbilityBuyScreenMessage;
import net.threetag.palladium.network.PalladiumNetwork;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityReference;
import net.threetag.palladiumcore.network.MessageC2S;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageType;
import org.jetbrains.annotations.NotNull;

public class RequestAbilityBuyScreenMessage
extends MessageC2S {
    private final AbilityReference reference;

    public RequestAbilityBuyScreenMessage(AbilityReference reference) {
        this.reference = reference;
    }

    public RequestAbilityBuyScreenMessage(class_2540 buf) {
        this.reference = AbilityReference.fromBuffer(buf);
    }

    @NotNull
    public MessageType getType() {
        return PalladiumNetwork.REQUEST_ABILITY_BUY_SCREEN;
    }

    public void toBytes(class_2540 buf) {
        this.reference.toBuffer(buf);
    }

    public void handle(MessageContext context) {
        BuyableCondition buyableCondition;
        AbilityInstance entry = this.reference.getEntry((class_1309)context.getPlayer());
        if (entry != null && (buyableCondition = entry.getConfiguration().findBuyCondition()) != null && !entry.getProperty(BuyableCondition.BOUGHT).booleanValue()) {
            for (AbilityInstance parentEntry : Ability.findParentsWithinHolder(entry.getConfiguration(), entry.getHolder())) {
                if (parentEntry.isUnlocked()) continue;
                return;
            }
            new OpenAbilityBuyScreenMessage(this.reference, buyableCondition.createData(), buyableCondition.isAvailable((class_1309)context.getPlayer())).send(context.getPlayer());
        }
    }
}

