/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.item.SuitSet;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladiumcore.registry.ReloadListenerRegistry;
import org.jetbrains.annotations.Nullable;

public class SuitSetPowerManager
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static SuitSetPowerManager INSTANCE;
    private final Map<SuitSet, List<Power>> suitSetPowers = new HashMap<SuitSet, List<Power>>();

    public static void init() {
        INSTANCE = new SuitSetPowerManager();
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (class_2960)Palladium.id("suit_set_powers"), (class_3302)INSTANCE);
    }

    public SuitSetPowerManager() {
        super(GSON, "palladium/suit_set_powers");
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        this.suitSetPowers.clear();
        object.forEach((id, json) -> {
            try {
                JsonObject jsonObject = class_3518.method_15295((JsonElement)json, (String)"$");
                ArrayList<Object> powers = new ArrayList<Object>();
                if (jsonObject.get("power").isJsonPrimitive()) {
                    Power power = PowerManager.getInstance(null).getPower(new class_2960(jsonObject.get("power").getAsString()));
                    if (power == null) {
                        AddonPackLog.warning("Unknown power used for suit set '" + jsonObject.get("power").getAsString() + "'", new Object[0]);
                    } else {
                        powers.add(power);
                    }
                } else if (jsonObject.get("power").isJsonArray()) {
                    for (JsonElement jsonElement : class_3518.method_15261((JsonObject)jsonObject, (String)"power")) {
                        Power power = PowerManager.getInstance(null).getPower(new class_2960(jsonElement.getAsString()));
                        if (power == null) {
                            AddonPackLog.warning("Unknown power used for suit set '" + jsonElement.getAsString() + "'", new Object[0]);
                            continue;
                        }
                        powers.add(power);
                    }
                } else {
                    throw new JsonSyntaxException("Expected power to be string or array of strings");
                }
                List<Object> suitSets = new ArrayList();
                if (jsonObject.get("suit_set").isJsonPrimitive()) {
                    class_2960 suitSetId = new class_2960(jsonObject.get("suit_set").getAsString());
                    if (!SuitSet.REGISTRY.containsKey(suitSetId)) {
                        throw new JsonParseException("Unknown suit set '" + String.valueOf(suitSetId) + "'");
                    }
                    suitSets = List.of(Objects.requireNonNull((SuitSet)SuitSet.REGISTRY.get(suitSetId)));
                } else if (jsonObject.get("suit_set").isJsonArray()) {
                    for (JsonElement jsonElement : class_3518.method_15261((JsonObject)jsonObject, (String)"suit_set")) {
                        class_2960 suitSetId = new class_2960(jsonElement.getAsString());
                        if (!SuitSet.REGISTRY.containsKey(suitSetId)) {
                            throw new JsonParseException("Unknown suit set '" + String.valueOf(suitSetId) + "'");
                        }
                        suitSets.add((SuitSet)SuitSet.REGISTRY.get(suitSetId));
                    }
                } else {
                    throw new JsonSyntaxException("Expected suit set to be string or array of strings");
                }
                for (SuitSet suitSet : suitSets) {
                    this.suitSetPowers.computeIfAbsent(suitSet, suitSet1 -> new ArrayList()).addAll(powers);
                }
            }
            catch (Exception exception) {
                AddonPackLog.error("Parsing error loading suit set powers {}", id, exception);
            }
        });
        AddonPackLog.info("Loaded {} suit set powers", this.suitSetPowers.size());
    }

    @Nullable
    public List<Power> getPowerForSuitSet(SuitSet suitSet) {
        return this.suitSetPowers.get(suitSet);
    }

    public static SuitSetPowerManager getInstance() {
        return INSTANCE;
    }
}

