/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;

public class AbilityDescription {
    private final class_2561 lockedDescription;
    private final class_2561 unlockedDescription;

    public AbilityDescription(class_2561 lockedDescription, class_2561 unlockedDescription) {
        this.lockedDescription = lockedDescription;
        this.unlockedDescription = unlockedDescription;
    }

    public AbilityDescription(class_2561 description) {
        this.lockedDescription = this.unlockedDescription = description;
    }

    public class_2561 get(boolean unlocked) {
        return unlocked ? this.unlockedDescription : this.lockedDescription;
    }

    public static AbilityDescription fromJson(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return new AbilityDescription((class_2561)class_2561.class_2562.method_10872((JsonElement)jsonElement));
        }
        if (jsonElement.isJsonObject()) {
            JsonObject obj = jsonElement.getAsJsonObject();
            if (obj.has("locked") && obj.has("unlocked")) {
                return new AbilityDescription((class_2561)class_2561.class_2562.method_10872((JsonElement)obj.get("locked")), (class_2561)class_2561.class_2562.method_10872((JsonElement)obj.get("unlocked")));
            }
            return new AbilityDescription((class_2561)class_2561.class_2562.method_10872((JsonElement)jsonElement));
        }
        return new AbilityDescription((class_2561)class_2561.class_2562.method_10872((JsonElement)jsonElement));
    }

    public JsonElement toJson() {
        if (this.lockedDescription == this.unlockedDescription) {
            return class_2561.class_2562.method_10868((class_2561)this.lockedDescription);
        }
        JsonObject json = new JsonObject();
        json.add("locked", class_2561.class_2562.method_10868((class_2561)this.lockedDescription));
        json.add("unlocked", class_2561.class_2562.method_10868((class_2561)this.unlockedDescription));
        return json;
    }

    public static AbilityDescription fromNbt(class_2487 nbt) {
        String unlocked;
        String locked = nbt.method_10558("Locked");
        if (locked.equals(unlocked = nbt.method_10558("Unlocked"))) {
            return new AbilityDescription((class_2561)class_2561.class_2562.method_10877((String)locked));
        }
        return new AbilityDescription((class_2561)class_2561.class_2562.method_10877((String)locked), (class_2561)class_2561.class_2562.method_10877((String)unlocked));
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10582("Locked", class_2561.class_2562.method_10867((class_2561)this.lockedDescription));
        nbt.method_10582("Unlocked", class_2561.class_2562.method_10867((class_2561)this.unlockedDescription));
        return nbt;
    }

    public static AbilityDescription fromBuffer(class_2540 buf) {
        boolean same = buf.readBoolean();
        if (same) {
            return new AbilityDescription(buf.method_10808());
        }
        return new AbilityDescription(buf.method_10808(), buf.method_10808());
    }

    public void toBuffer(class_2540 buf) {
        buf.writeBoolean(this.lockedDescription == this.unlockedDescription);
        buf.method_10805(this.lockedDescription);
        if (this.lockedDescription != this.unlockedDescription) {
            buf.method_10805(this.unlockedDescription);
        }
    }
}

