/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.Collections;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2158;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8109;
import net.threetag.palladium.client.energybeam.EnergyBeamConfiguration;
import net.threetag.palladium.client.energybeam.EnergyBeamManager;
import net.threetag.palladium.entity.PalladiumDamageTypes;
import net.threetag.palladium.entity.effect.EnergyBeamEffect;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AnimationTimer;
import net.threetag.palladium.util.EntityUtil;
import net.threetag.palladium.util.PalladiumBlockUtil;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.CommandFunctionProperty;
import net.threetag.palladium.util.property.FloatProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PropertyManager;
import net.threetag.palladium.util.property.ResourceLocationProperty;
import net.threetag.palladium.util.property.SyncType;
import net.threetag.palladium.util.property.Vec3Property;
import net.threetag.palladiumcore.util.Platform;

public class EnergyBeamAbility
extends Ability
implements AnimationTimer,
class_2165 {
    public static final PalladiumProperty<class_2960> BEAM = new ResourceLocationProperty("energy_beam").configurable("Configuration for the look of the beam. Check wiki for information.");
    public static final PalladiumProperty<class_2960> DAMAGE_TYPE = new ResourceLocationProperty("damage_type").configurable("Damage type which is applied when an entity is hit. Uses normal player/mob attack if null/unchanged.");
    public static final PalladiumProperty<Float> DAMAGE = new FloatProperty("damage").configurable("The damage dealt with aiming for entities (per tick)");
    public static final PalladiumProperty<Float> MAX_DISTANCE = new FloatProperty("max_distance").configurable("The maximum distance you can reach with your heat vision");
    public static final PalladiumProperty<Float> SPEED = new FloatProperty("speed").configurable("Speed at which the energy beam extends from the player. Use 0 for instant extension.");
    public static final PalladiumProperty<Integer> SET_ON_FIRE_SECONDS = new IntegerProperty("set_on_fire_seconds").configurable("You can use this to set targeted entities on fire. If set to 0 it will not cause any.");
    public static final PalladiumProperty<Boolean> CAUSE_FIRE = new BooleanProperty("cause_fire").configurable("If enabled, targeted blocks will start to burn (fire will be placed).");
    public static final PalladiumProperty<Boolean> SMELT_BLOCKS = new BooleanProperty("smelt_blocks").configurable("If enabled, targeted blocks will turn into their smelting result (e.g. sand will turn into glass).");
    public static final PalladiumProperty<CommandFunctionProperty.CommandFunctionParsing> COMMANDS_ON_BLOCK_HIT = new CommandFunctionProperty("commands_on_block_hit").sync(SyncType.NONE).disablePersistence().configurable("Sets the commands which get executed when the beam hits an object");
    public static final PalladiumProperty<CommandFunctionProperty.CommandFunctionParsing> COMMANDS_ON_ENTITY_HIT = new CommandFunctionProperty("commands_on_entity_hit").sync(SyncType.NONE).disablePersistence().configurable("Sets the commands which get executed when the beam hits an object");
    public static final PalladiumProperty<class_243> TARGET = new Vec3Property("distance").sync(SyncType.NONE);
    public static final PalladiumProperty<Float> VALUE = new FloatProperty("value").sync(SyncType.NONE).disablePersistence();
    public static final PalladiumProperty<Float> PREV_VALUE = new FloatProperty("prev_value").sync(SyncType.NONE).disablePersistence();

    public EnergyBeamAbility() {
        this.withProperty(BEAM, new class_2960("example:energy_beam")).withProperty(DAMAGE_TYPE, null).withProperty(DAMAGE, Float.valueOf(5.0f)).withProperty(MAX_DISTANCE, Float.valueOf(30.0f)).withProperty(SPEED, Float.valueOf(0.5f)).withProperty(SET_ON_FIRE_SECONDS, 0).withProperty(CAUSE_FIRE, false).withProperty(SMELT_BLOCKS, false).withProperty(COMMANDS_ON_BLOCK_HIT, new CommandFunctionProperty.CommandFunctionParsing(Collections.emptyList())).withProperty(COMMANDS_ON_ENTITY_HIT, new CommandFunctionProperty.CommandFunctionParsing(Collections.emptyList()));
    }

    @Override
    public void registerUniqueProperties(PropertyManager manager) {
        manager.register(TARGET, class_243.field_1353);
        manager.register(VALUE, Float.valueOf(0.0f));
        manager.register(PREV_VALUE, Float.valueOf(0.0f));
    }

    @Override
    public void firstTick(class_1309 entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (entry.getProperty(VALUE).floatValue() <= 0.0f && Platform.isClient()) {
                EnergyBeamEffect.start(player, entry.getReference());
            }
        }
    }

    @Override
    public void tick(class_1309 entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        float speed = entry.getProperty(SPEED).floatValue();
        float value = entry.getProperty(VALUE).floatValue();
        entry.setUniqueProperty(PREV_VALUE, Float.valueOf(value));
        class_239 hit = null;
        boolean active = enabled;
        if (speed > 0.0f) {
            hit = EnergyBeamAbility.updateTargetPos(entity, entry, 1.0f);
            if (entry.isEnabled() && value < 1.0f) {
                value = Math.min(value + speed, 1.0f);
                entry.setUniqueProperty(VALUE, Float.valueOf(value));
            } else if (!entry.isEnabled() && value > 0.0f) {
                value = Math.max(value - speed, 0.0f);
                entry.setUniqueProperty(VALUE, Float.valueOf(value));
            }
            boolean bl = active = value >= 1.0f;
        }
        if (active) {
            if (hit instanceof class_3966) {
                class_1937 customType;
                Float dmg;
                class_3966 entityHitResult = (class_3966)hit;
                Integer fireSecs = entry.getProperty(SET_ON_FIRE_SECONDS);
                if (fireSecs > 0) {
                    entityHitResult.method_17782().method_5639(fireSecs.intValue());
                }
                if ((dmg = entry.getProperty(DAMAGE)).floatValue() > 0.0f) {
                    class_8109 dmgSources = entity.method_37908().method_48963();
                    customType = entry.getProperty(DAMAGE_TYPE);
                    class_1282 damageSrc = dmgSources.method_48797(customType != null ? class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)customType) : PalladiumDamageTypes.ENERGY_BEAM, (class_1297)entity, (class_1297)entity);
                    entityHitResult.method_17782().method_5643(damageSrc, dmg.floatValue());
                }
                if (Platform.isClient()) {
                    this.spawnParticles(entity.method_37908(), hit.method_17784(), entry);
                }
                if ((customType = entity.method_37908()) instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)customType;
                    class_2168 source = this.createCommandSourceStack(entity, serverLevel, hit.method_17784());
                    class_2158 function = entry.getProperty(COMMANDS_ON_ENTITY_HIT).getCommandFunction(entity.method_37908().method_8503());
                    if (function != null) {
                        Objects.requireNonNull(entity.method_37908().method_8503()).method_3740().method_12904(function, source.method_9217().method_9230(2));
                    }
                }
            } else if (hit instanceof class_3965) {
                class_3965 blockHitResult = (class_3965)hit;
                class_2680 blockState = entity.method_37908().method_8320(blockHitResult.method_17777());
                if (!blockState.method_26215()) {
                    class_1937 serverLevel;
                    if (entry.getProperty(SMELT_BLOCKS).booleanValue()) {
                        class_1277 simpleContainer = new class_1277(new class_1799[]{new class_1799((class_1935)blockState.method_26204())});
                        entity.method_37908().method_8433().method_8132(class_3956.field_17546, (class_1263)simpleContainer, entity.method_37908()).ifPresent(recipe -> {
                            class_1799 result = recipe.method_8116((class_1263)simpleContainer, entity.method_37908().method_30349());
                            if (!result.method_7960() && class_2248.method_9503((class_1792)result.method_7909()) != class_2246.field_10124) {
                                entity.method_37908().method_8501(blockHitResult.method_17777(), class_2248.method_9503((class_1792)result.method_7909()).method_9564());
                            }
                        });
                        blockState = entity.method_37908().method_8320(blockHitResult.method_17777());
                    }
                    if (entry.getProperty(CAUSE_FIRE).booleanValue() && PalladiumBlockUtil.canBurn(blockState, (class_1922)entity.method_37908(), blockHitResult.method_17777(), blockHitResult.method_17780())) {
                        class_2338 pos = blockHitResult.method_17777().method_10081(blockHitResult.method_17780().method_10163());
                        if (entity.method_37908().method_22347(pos)) {
                            entity.method_37908().method_8501(pos, class_2246.field_10036.method_9564());
                        }
                    }
                    if (Platform.isClient()) {
                        this.spawnParticles(entity.method_37908(), hit.method_17784(), entry);
                    }
                    if ((serverLevel = entity.method_37908()) instanceof class_3218) {
                        class_3218 serverLevel2 = (class_3218)serverLevel;
                        class_2168 source = this.createCommandSourceStack(entity, serverLevel2, hit.method_17784());
                        class_2158 function = entry.getProperty(COMMANDS_ON_BLOCK_HIT).getCommandFunction(entity.method_37908().method_8503());
                        if (function != null) {
                            Objects.requireNonNull(entity.method_37908().method_8503()).method_3740().method_12904(function, source.method_9217().method_9230(2));
                        }
                    }
                }
            }
        }
    }

    public class_2168 createCommandSourceStack(class_1309 entity, class_3218 serverLevel, class_243 position) {
        return new class_2168((class_2165)this, position, entity.method_5802(), serverLevel, 2, entity.method_5477().getString(), entity.method_5476(), entity.method_37908().method_8503(), (class_1297)entity).method_9217();
    }

    @Environment(value=EnvType.CLIENT)
    public void spawnParticles(class_1937 level, class_243 pos, AbilityInstance entry) {
        EnergyBeamConfiguration beam = EnergyBeamManager.INSTANCE.get(entry.getProperty(BEAM));
        if (beam != null) {
            beam.spawnParticles(level, pos);
        }
    }

    public static class_239 updateTargetPos(class_1309 living, AbilityInstance entry, float partialTick) {
        class_243 start = living.method_5836(partialTick);
        class_243 end = start.method_1019(EntityUtil.getLookVector((class_1297)living, partialTick).method_1021((double)entry.getProperty(MAX_DISTANCE).floatValue()));
        class_239 endHit = EntityUtil.rayTraceWithEntities((class_1297)living, start, end, start.method_1022(end), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, en -> true);
        entry.setUniqueProperty(TARGET, endHit.method_17784());
        return endHit;
    }

    @Override
    public float getAnimationValue(AbilityInstance entry, float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)entry.getProperty(PREV_VALUE).floatValue(), (float)entry.getProperty(VALUE).floatValue());
    }

    @Override
    public float getAnimationTimer(AbilityInstance entry, float partialTick, boolean maxedOut) {
        if (maxedOut) {
            return 1.0f;
        }
        return class_3532.method_16439((float)partialTick, (float)entry.getProperty(PREV_VALUE).floatValue(), (float)entry.getProperty(VALUE).floatValue());
    }

    public void method_43496(class_2561 component) {
    }

    public boolean method_9200() {
        return false;
    }

    public boolean method_9202() {
        return false;
    }

    public boolean method_9201() {
        return false;
    }
}

