/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2350;
import net.minecraft.class_3518;
import net.minecraft.class_5603;
import net.minecraft.class_5604;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5611;
import net.threetag.palladium.client.model.ExtendedCubeListBuilder;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BedrockModelUtil {
    public static class_5607 parseAsLayerDefinition(JsonObject json) {
        JsonArray geometry = class_3518.method_15261((JsonObject)json, (String)"minecraft:geometry");
        if (geometry.isEmpty()) {
            throw new JsonParseException("Empty geometry!");
        }
        class_5609 meshDefinition = new class_5609();
        class_5610 root = meshDefinition.method_32111();
        JsonObject geo = class_3518.method_15295((JsonElement)geometry.get(0), (String)"minecraft:geometry[].$");
        JsonObject description = class_3518.method_15281((JsonObject)geo, (String)"description", (JsonObject)new JsonObject());
        int textureWidth = class_3518.method_15260((JsonObject)description, (String)"texture_width");
        int textureHeight = class_3518.method_15260((JsonObject)description, (String)"texture_height");
        JsonArray bones = class_3518.method_15292((JsonObject)geo, (String)"bones", (JsonArray)new JsonArray());
        HashMap<String, BedrockModelPartCache> cache = new HashMap<String, BedrockModelPartCache>();
        HashMap<String, class_5610> modelParts = new HashMap<String, class_5610>();
        for (JsonElement b : bones) {
            JsonObject bone = class_3518.method_15295((JsonElement)b, (String)"minecraft:geomeotry[].bones.$");
            String name = class_3518.method_15265((JsonObject)bone, (String)"name");
            String parent = class_3518.method_15253((JsonObject)bone, (String)"parent", null);
            float[] pivot = GsonUtil.getFloatArray(bone, 3, "pivot", 0.0f, 0.0f, 0.0f);
            float[] rotation = GsonUtil.getFloatArray(bone, 3, "rotation", 0.0f, 0.0f, 0.0f);
            JsonArray cubesJson = class_3518.method_15292((JsonObject)bone, (String)"cubes", (JsonArray)new JsonArray());
            ArrayList<BedrockModelCube> cubes = new ArrayList<BedrockModelCube>();
            for (JsonElement cj : cubesJson) {
                JsonObject cubeJson = class_3518.method_15295((JsonElement)cj, (String)"minecraft:geomeotry[].bones[].cubes[].$");
                float[] origin = GsonUtil.getFloatArray(cubeJson, 3, "origin");
                float[] size = GsonUtil.getFloatArray(cubeJson, 3, "size");
                float inflate = class_3518.method_15277((JsonObject)cubeJson, (String)"inflate", (float)0.0f);
                JsonElement uvJson = cubeJson.get("uv");
                boolean mirror = class_3518.method_15258((JsonObject)cubeJson, (String)"mirror", (boolean)false);
                if (uvJson.isJsonArray()) {
                    int[] uv = GsonUtil.getIntArray(cubeJson, 2, "uv", 0, 0);
                    cubes.add(new BedrockModelCube(new Vector3f(origin[0], origin[1], origin[2]), new Vector3f(size[0], size[1], size[2]), inflate, mirror, new class_5611((float)uv[0], (float)uv[1])));
                    continue;
                }
                JsonObject uvs = class_3518.method_15295((JsonElement)uvJson, (String)"minecraft:geomeotry[].bones[].cubes[].uv");
                HashMap<class_2350, ExtendedCubeListBuilder.PerFaceUV> uvMap = new HashMap<class_2350, ExtendedCubeListBuilder.PerFaceUV>();
                for (class_2350 direction : class_2350.values()) {
                    if (!class_3518.method_15294((JsonObject)uvs, (String)direction.method_10151())) continue;
                    JsonObject directionJson = class_3518.method_15296((JsonObject)uvs, (String)direction.method_10151());
                    int[] uv = GsonUtil.getIntArray(directionJson, 2, "uv", 0, 0);
                    int[] uvSize = GsonUtil.getIntArray(directionJson, 2, "uv_size", 0, 0);
                    uvMap.put(direction.method_10166() == class_2350.class_2351.field_11051 ? direction : direction.method_10153(), new ExtendedCubeListBuilder.PerFaceUV(new class_5611((float)uv[0], (float)uv[1]), new class_5611((float)uvSize[0], (float)uvSize[1])));
                }
                cubes.add(new BedrockModelCube(new Vector3f(origin[0], origin[1], origin[2]), new Vector3f(size[0], size[1], size[2]), inflate, mirror, uvMap));
            }
            cache.put(name, new BedrockModelPartCache(name, parent, new Vector3f(pivot[0], pivot[1], pivot[2]), new Vector3f((float)Math.toRadians(rotation[0]), (float)Math.toRadians(rotation[1]), (float)Math.toRadians(rotation[2])), cubes));
        }
        for (Map.Entry e : cache.entrySet()) {
            if (((BedrockModelPartCache)e.getValue()).parentName == null) continue;
            if (!cache.containsKey(((BedrockModelPartCache)e.getValue()).parentName)) {
                throw new JsonParseException("Unknown parent '" + ((BedrockModelPartCache)e.getValue()).parentName + "'");
            }
            ((BedrockModelPartCache)e.getValue()).parent = (BedrockModelPartCache)cache.get(((BedrockModelPartCache)e.getValue()).parentName);
            ((BedrockModelPartCache)cache.get((Object)((BedrockModelPartCache)e.getValue()).parentName)).children.add((BedrockModelPartCache)e.getValue());
        }
        while (!cache.isEmpty()) {
            HashMap copy = new HashMap(cache);
            for (Map.Entry e : copy.entrySet()) {
                if (((BedrockModelPartCache)e.getValue()).parentName == null) {
                    BedrockModelUtil.convertHierarchy((BedrockModelPartCache)e.getValue(), "");
                    modelParts.put((String)e.getKey(), ((BedrockModelPartCache)e.getValue()).add(root));
                    cache.remove(e.getKey());
                    continue;
                }
                class_5610 parent = (class_5610)modelParts.get(((BedrockModelPartCache)e.getValue()).parentName);
                if (parent == null) continue;
                modelParts.put((String)e.getKey(), ((BedrockModelPartCache)e.getValue()).add(parent));
                cache.remove(e.getKey());
            }
        }
        return class_5607.method_32110((class_5609)meshDefinition, (int)textureWidth, (int)textureHeight);
    }

    private static void convertHierarchy(BedrockModelPartCache part, String prefix) {
        part.convert();
        for (BedrockModelPartCache child : part.children) {
            BedrockModelUtil.convertHierarchy(child, prefix + "  ");
        }
    }

    public static JsonObject toJsonModel(class_5607 layerDefinition, @Nullable String identifier) {
        JsonObject json = new JsonObject();
        json.addProperty("format_version", "1.12.0");
        JsonArray geometryArray = new JsonArray();
        JsonObject geometry = new JsonObject();
        JsonObject description = new JsonObject();
        description.addProperty("identifier", identifier != null ? identifier : "geometry.unknown");
        description.addProperty("texture_width", (Number)layerDefinition.field_27724.field_27725);
        description.addProperty("texture_height", (Number)layerDefinition.field_27724.field_27726);
        geometry.add("description", (JsonElement)description);
        JsonArray bones = new JsonArray();
        layerDefinition.field_27723.method_32111().field_27730.forEach((s, part) -> BedrockModelUtil.addBoneToArray(bones, s, part, new ArrayList<class_5610>(), null));
        geometry.add("bones", (JsonElement)bones);
        geometryArray.add((JsonElement)geometry);
        json.add("minecraft:geometry", (JsonElement)geometryArray);
        return json;
    }

    private static void addBoneToArray(JsonArray array, String name, class_5610 part, List<class_5610> parents, @Nullable String parent) {
        JsonObject json = new JsonObject();
        json.addProperty("name", name);
        if (parent != null) {
            json.addProperty("parent", parent);
        }
        Vector3f fixedPivot = new Vector3f(part.field_27729.field_27702, part.field_27729.field_27703, part.field_27729.field_27704);
        for (class_5610 class_56102 : parents) {
            fixedPivot.add(class_56102.field_27729.field_27702, class_56102.field_27729.field_27703, class_56102.field_27729.field_27704);
        }
        fixedPivot.sub(0.0f, 24.0f, 0.0f).mul(1.0f, -1.0f, 1.0f);
        json.add("pivot", (JsonElement)BedrockModelUtil.vec3ToJsonArray(fixedPivot));
        json.add("rotation", (JsonElement)BedrockModelUtil.vec3ToJsonArray(Math.toDegrees(part.field_27729.field_27705), Math.toDegrees(part.field_27729.field_27706), Math.toDegrees(part.field_27729.field_27707)));
        JsonArray cubes = new JsonArray();
        for (class_5604 c : part.field_27728) {
            JsonObject cube = new JsonObject();
            Vector3f fixedOrigin = new Vector3f().set((Vector3fc)c.field_27709).add(fixedPivot.x, 0.0f, fixedPivot.z);
            fixedOrigin.y = (fixedOrigin.y + c.field_27710.y - fixedPivot.y) * -1.0f;
            cube.add("origin", (JsonElement)BedrockModelUtil.vec3ToJsonArray(fixedOrigin));
            cube.add("size", (JsonElement)BedrockModelUtil.vec3ToJsonArray(c.field_27710));
            cube.addProperty("inflate", (Number)((double)(c.field_27711.field_27716 + c.field_27711.field_27717 + c.field_27711.field_27718) / 3.0));
            if (c instanceof ExtendedCubeListBuilder.PerFaceCubeDefinition) {
                ExtendedCubeListBuilder.PerFaceCubeDefinition perFace = (ExtendedCubeListBuilder.PerFaceCubeDefinition)c;
                JsonObject uv = new JsonObject();
                for (Map.Entry<class_2350, ExtendedCubeListBuilder.PerFaceUV> e : perFace.uvMap.entrySet()) {
                    JsonObject face = new JsonObject();
                    class_2350 direction = e.getKey();
                    face.add("uv", (JsonElement)BedrockModelUtil.uvPairToJsonArray(e.getValue().uv()));
                    face.add("uv_size", (JsonElement)BedrockModelUtil.uvPairToJsonArray(e.getValue().size()));
                    uv.add(direction.method_10166() == class_2350.class_2351.field_11051 ? direction.method_10151() : direction.method_10153().method_10151(), (JsonElement)face);
                }
                cube.add("uv", (JsonElement)uv);
            } else {
                cube.add("uv", (JsonElement)BedrockModelUtil.uvPairToJsonArray(c.field_27713));
            }
            cube.addProperty("mirror", Boolean.valueOf(c.field_27712));
            cubes.add((JsonElement)cube);
        }
        json.add("cubes", (JsonElement)cubes);
        array.add((JsonElement)json);
        ArrayList<class_5610> arrayList = new ArrayList<class_5610>(parents);
        arrayList.add(part);
        part.field_27730.forEach((n, p) -> BedrockModelUtil.addBoneToArray(array, n, p, newParents, name));
    }

    private static JsonArray vec3ToJsonArray(Vector3f vec) {
        JsonArray array = new JsonArray();
        array.add((Number)Float.valueOf(vec.x));
        array.add((Number)Float.valueOf(vec.y));
        array.add((Number)Float.valueOf(vec.z));
        return array;
    }

    private static JsonArray vec3ToJsonArray(double x, double y, double z) {
        JsonArray array = new JsonArray();
        array.add((Number)x);
        array.add((Number)y);
        array.add((Number)z);
        return array;
    }

    private static JsonArray uvPairToJsonArray(class_5611 uv) {
        JsonArray array = new JsonArray();
        array.add((Number)Float.valueOf(uv.method_32118()));
        array.add((Number)Float.valueOf(uv.method_32119()));
        return array;
    }

    public static class BedrockModelCube {
        private final Vector3f origin;
        private final Vector3f size;
        private final float inflate;
        private final class_5611 uv;
        private final Map<class_2350, ExtendedCubeListBuilder.PerFaceUV> uvMap;
        private final boolean mirror;

        public BedrockModelCube(Vector3f origin, Vector3f size, float inflate, boolean mirror, class_5611 uv) {
            this.origin = origin;
            this.size = size;
            this.inflate = inflate;
            this.mirror = mirror;
            this.uv = uv;
            this.uvMap = null;
        }

        public BedrockModelCube(Vector3f origin, Vector3f size, float inflate, boolean mirror, Map<class_2350, ExtendedCubeListBuilder.PerFaceUV> uvMap) {
            this.origin = origin;
            this.size = size;
            this.inflate = inflate;
            this.mirror = mirror;
            this.uv = null;
            this.uvMap = uvMap;
        }

        public void add(ExtendedCubeListBuilder builder) {
            if (this.uv != null) {
                builder.method_32106(this.mirror).method_32101((int)this.uv.method_32118(), (int)this.uv.method_32119()).method_32098(this.origin.x, this.origin.y, this.origin.z, this.size.x, this.size.y, this.size.z, new class_5605(this.inflate));
            } else {
                ExtendedCubeListBuilder.PerFaceCubeBuilder cubeBuilder = builder.addPerFaceUVCube().origin(this.origin).dimensions(this.size).grow(this.inflate);
                for (Map.Entry<class_2350, ExtendedCubeListBuilder.PerFaceUV> e : Objects.requireNonNull(this.uvMap).entrySet()) {
                    cubeBuilder.addFace(e.getKey(), e.getValue().uv(), e.getValue().size());
                }
                cubeBuilder.build();
            }
        }

        public void convert(Vector3f pivot, String name) {
            this.origin.sub(pivot.x, 0.0f, pivot.z);
            this.origin.y = pivot.y - this.origin.y - this.size.y;
        }
    }

    public static class BedrockModelPartCache {
        private final String name;
        @Nullable
        public final String parentName;
        public BedrockModelPartCache parent;
        public List<BedrockModelPartCache> children = new ArrayList<BedrockModelPartCache>();
        private final Vector3f unconvertedPivot;
        private final Vector3f pivot;
        private final Vector3f rotation;
        private final List<BedrockModelCube> cubes;

        public BedrockModelPartCache(String name, @Nullable String parentName, Vector3f pivot, Vector3f rotation, List<BedrockModelCube> cubes) {
            this.name = name;
            this.parentName = parentName;
            this.unconvertedPivot = pivot;
            this.pivot = pivot;
            this.rotation = rotation;
            this.cubes = cubes;
        }

        public class_5610 add(class_5610 parent) {
            ExtendedCubeListBuilder builder = ExtendedCubeListBuilder.create();
            for (BedrockModelCube cube : this.cubes) {
                cube.add(builder);
            }
            return parent.method_32117(this.name, (class_5606)builder, class_5603.method_32091((float)this.pivot.x, (float)this.pivot.y, (float)this.pivot.z, (float)this.rotation.x, (float)this.rotation.y, (float)this.rotation.z));
        }

        public BedrockModelPartCache convert() {
            this.cubes.forEach(c -> c.convert(this.pivot, this.name));
            this.pivot.mul(1.0f, -1.0f, 1.0f).add(0.0f, 24.0f, 0.0f);
            BedrockModelPartCache parent = this.parent;
            while (parent != null) {
                this.pivot.sub((Vector3fc)parent.unconvertedPivot);
                parent = parent.parent;
            }
            return this;
        }
    }
}

