/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.accessory.AccessoryPlayerData;
import net.threetag.palladiumcore.event.PlayerEvents;
import net.threetag.palladiumcore.util.Platform;
import org.jetbrains.annotations.Nullable;

public class SupporterHandler {
    private static final String BASE_URL = "https://squirrelcontrol.threetag.net/api/";
    private static final Map<UUID, PlayerData> DATA = Maps.newHashMap();
    private static boolean CHECK = false;

    public static void init() {
        PlayerEvents.JOIN.register(player -> {
            SupporterHandler.loadPlayerData(player.method_5667());
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                if (CHECK && !SupporterHandler.getPlayerData(player.method_5667()).hasModAccess()) {
                    serverPlayer.field_13987.method_14367((class_2561)class_2561.method_43470((String)"You are not allowed to use this mod!"));
                }
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void clientInit() {
        PlayerEvents.CLIENT_JOIN.register(player -> SupporterHandler.loadPlayerData(player.method_5667()));
        PlayerEvents.CLIENT_QUIT.register(player -> {
            if (player != null) {
                DATA.remove(player.method_5667());
            }
        });
    }

    public static void loadPlayerData(UUID uuid) {
        CompletableFuture.runAsync(() -> {
            try {
                class_3222 player;
                JsonObject json = SupporterHandler.readJsonFromUrl("https://squirrelcontrol.threetag.net/api/player/" + uuid.toString());
                PlayerData data = new PlayerData(uuid, class_3518.method_15296((JsonObject)json, (String)"data"));
                DATA.put(uuid, data);
                Palladium.LOGGER.info("Successfully read user's supporter data! ({})", (Object)uuid);
                if (Platform.getCurrentServer() != null && (player = Platform.getCurrentServer().method_3760().method_14602(uuid)) != null) {
                    Accessory.getPlayerData((class_1657)player).ifPresent(arg_0 -> SupporterHandler.lambda$loadPlayerData$3((class_1657)player, arg_0));
                }
                return;
            }
            catch (Exception e) {
                if (!Platform.isProduction()) {
                    Palladium.LOGGER.warn("Was not able to read user's supporter data! ({})", (Object)uuid.toString());
                }
                PlayerData data = new PlayerData(uuid, new JsonObject());
                DATA.put(uuid, data);
                return;
            }
        }, class_156.method_18349()).join();
    }

    public static void enableSupporterCheck() {
        if (!CHECK) {
            CHECK = true;
            Palladium.LOGGER.info("The supporter check has been enabled!");
        }
    }

    public static boolean isSupporterCheckEnabled() {
        return CHECK;
    }

    public static PlayerData getPlayerData(UUID uuid) {
        if (DATA.containsKey(uuid)) {
            return DATA.get(uuid);
        }
        PlayerData data = new PlayerData(uuid, new JsonObject());
        DATA.put(uuid, data);
        return data;
    }

    public static PlayerData getPlayerDataUnsafe(UUID uuid) {
        return DATA.get(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonObject readJsonFromUrl(String url) throws Exception {
        try (InputStream is = new URL(url).openStream();){
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            JsonObject json = new JsonParser().parse((Reader)rd).getAsJsonObject();
            if (class_3518.method_15260((JsonObject)json, (String)"error") != 200) {
                throw new Exception("Error while reading json: " + class_3518.method_15265((JsonObject)json, (String)"message"));
            }
            JsonObject jsonObject = json;
            return jsonObject;
        }
    }

    private static /* synthetic */ void lambda$loadPlayerData$3(class_1657 player, AccessoryPlayerData accessoryData) {
        accessoryData.validate(player);
    }

    public static class PlayerData {
        private final UUID uuid;
        private final List<Accessory> accessories;
        private final boolean modAccess;
        private final boolean hasCloak;
        private class_2960 cloakTexture;

        public PlayerData(UUID uuid, JsonObject json) {
            this.uuid = uuid;
            this.accessories = new ArrayList<Accessory>();
            JsonArray data = class_3518.method_15292((JsonObject)json, (String)"accessoires", (JsonArray)new JsonArray());
            for (int i = 0; i < data.size(); ++i) {
                class_2960 id = new class_2960(data.get(i).getAsString());
                if (id.method_12836().equalsIgnoreCase("threecore")) {
                    id = Palladium.id(id.method_12832());
                }
                if (!Accessory.REGISTRY.containsKey(id)) continue;
                this.accessories.add((Accessory)Accessory.REGISTRY.get(id));
            }
            this.modAccess = class_3518.method_15258((JsonObject)json, (String)"mod_access", (boolean)false);
            if (class_3518.method_15294((JsonObject)json, (String)"cloak")) {
                this.hasCloak = true;
                if (Platform.isClient()) {
                    this.loadCloakTexture(class_3518.method_15265((JsonObject)json, (String)"cloak"));
                }
            } else {
                this.hasCloak = false;
            }
        }

        @Environment(value=EnvType.CLIENT)
        public void loadCloakTexture(String url) {
            if (RenderSystem.isOnRenderThread()) {
                try {
                    class_2960 resourceLocation = Palladium.id("cloaks/" + this.uuid.toString());
                    class_310.method_1551().method_1531().method_4615(resourceLocation);
                    InputStream stream = new URL(url).openStream();
                    class_1011 image = class_1011.method_4309((InputStream)stream);
                    class_310.method_1551().method_1531().method_4616(resourceLocation, (class_1044)new class_1043(image));
                    stream.close();
                    this.cloakTexture = resourceLocation;
                }
                catch (IOException e) {
                    Palladium.LOGGER.error("Error loading supporter cloak texture: " + e.getMessage());
                }
            }
        }

        public boolean hasModAccess() {
            return this.modAccess;
        }

        public boolean hasAccessory(Accessory accessory) {
            return this.accessories.contains(accessory) || !Platform.isProduction();
        }

        public List<Accessory> getAccessories() {
            return ImmutableList.copyOf(this.accessories);
        }

        public boolean hasCloak() {
            return this.hasCloak;
        }

        @Nullable
        public class_2960 getCloakTexture() {
            return this.cloakTexture;
        }
    }
}

