/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1297;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.DoubleProperty;
import net.threetag.palladium.util.property.EntityPropertyHandler;
import net.threetag.palladium.util.property.EnumPalladiumProperty;
import net.threetag.palladium.util.property.FloatArrayProperty;
import net.threetag.palladium.util.property.FloatProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.ResourceLocationProperty;
import net.threetag.palladium.util.property.StringArrayProperty;
import net.threetag.palladium.util.property.SyncType;

public abstract class PalladiumProperty<T> {
    private final String key;
    private String description;
    private SyncType syncType = SyncType.EVERYONE;
    public final TypeToken<T> typeToken = new TypeToken<T>(this.getClass()){};
    private final Type type = this.typeToken.getType();
    private boolean persistent = true;

    public PalladiumProperty(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public SyncType getSyncType() {
        return this.syncType;
    }

    public Type getType() {
        return this.type;
    }

    public PalladiumProperty<T> disablePersistence() {
        this.persistent = false;
        return this;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public PalladiumProperty<T> configurable(String description) {
        this.description = description;
        return this;
    }

    public PalladiumProperty<T> sync(SyncType syncType) {
        this.syncType = syncType;
        return this;
    }

    public abstract T fromJSON(JsonElement var1);

    public abstract JsonElement toJSON(T var1);

    public abstract T fromNBT(class_2520 var1, T var2);

    public abstract class_2520 toNBT(T var1);

    public abstract T fromBuffer(class_2540 var1);

    public abstract void toBuffer(class_2540 var1, Object var2);

    public void set(class_1297 entity, T value) {
        EntityPropertyHandler.getHandler(entity).ifPresent(handler -> handler.set(this, value));
    }

    public T get(class_1297 entity) {
        AtomicReference<Comparable<Boolean>> result = new AtomicReference<Comparable<Boolean>>();
        if (this instanceof BooleanProperty) {
            result.set(Boolean.valueOf(false));
        } else if (this instanceof IntegerProperty) {
            result.set(Integer.valueOf(0));
        } else if (this instanceof FloatProperty) {
            result.set(Float.valueOf(0.0f));
        } else if (this instanceof DoubleProperty) {
            result.set(Double.valueOf(0.0));
        }
        EntityPropertyHandler.getHandler(entity).ifPresent(handler -> result.set((Comparable<Boolean>)handler.get(this)));
        return (T)result.get();
    }

    public boolean isRegistered(class_1297 entity) {
        AtomicBoolean result = new AtomicBoolean(false);
        EntityPropertyHandler.getHandler(entity).ifPresent(handler -> result.set(handler.isRegistered(this)));
        return result.get();
    }

    public String getString(T value) {
        return value == null ? null : value.toString();
    }

    public static Object fixValues(PalladiumProperty<?> property, Object value) {
        if (property instanceof IntegerProperty && value instanceof Number) {
            Number number = (Number)value;
            value = number.intValue();
        } else if (property instanceof FloatProperty && value instanceof Number) {
            Number number = (Number)value;
            value = Float.valueOf(number.floatValue());
        } else if (property instanceof DoubleProperty && value instanceof Number) {
            Number number = (Number)value;
            value = number.doubleValue();
        } else if (property instanceof ResourceLocationProperty && value instanceof String) {
            String string = (String)value;
            value = new class_2960(string);
        } else if (property instanceof EnumPalladiumProperty && value instanceof String) {
            String string = (String)value;
            value = ((EnumPalladiumProperty)property).getByName(string);
        } else if (property instanceof StringArrayProperty && value instanceof List) {
            List list = (List)value;
            String[] array = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                array[i] = list.get(i).toString();
            }
            value = array;
        } else if (property instanceof FloatArrayProperty && value instanceof List) {
            List list = (List)value;
            Float[] array = new Float[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                array[i] = Float.valueOf(list.get(i).toString());
            }
            value = array;
        }
        return value;
    }

    public String getPropertyType() {
        return null;
    }
}

